/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;

public class FormUploadToken {
    private final String url;
    private final String token;

    public FormUploadToken(String url, String token) {
        this.url = url;
        this.token = token;
    }

    public String getUrl() {
        return this.url;
    }

    public String getToken() {
        return this.token;
    }

    public static FormUploadToken parse(InputStream input) throws ParseException, IOException {
        ResponseElementHandler handler = new ResponseElementHandler();
        new XmlParser().parse(input, (XmlParser.ElementHandler)handler, "", "response");
        if (handler.getUrl() == null) {
            throw new ParseException("Missing or empty 'url' element in response");
        }
        if (handler.getToken() == null) {
            throw new ParseException("Missing or empty 'token' element in response");
        }
        return new FormUploadToken(handler.getUrl(), handler.getToken());
    }

    private static class ResponseElementHandler
    extends XmlParser.ElementHandler {
        private String url;
        private String token;

        private ResponseElementHandler() {
        }

        public String getUrl() {
            return this.url;
        }

        public String getToken() {
            return this.token;
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if ("".equals(namespace)) {
                if ("url".equals(localName)) {
                    return new XmlParser.ElementHandler(){

                        @Override
                        public void processEndElement() throws ParseException {
                            ResponseElementHandler.this.url = this.value;
                        }
                    };
                }
                if ("token".equals(localName)) {
                    return new XmlParser.ElementHandler(){

                        @Override
                        public void processEndElement() throws ParseException {
                            ResponseElementHandler.this.token = this.value;
                        }
                    };
                }
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

