/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="age")
public class YtAge
extends AbstractExtension {
    private int age;

    public YtAge() {
    }

    public YtAge(int age) {
        this.age = age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getAge() {
        return this.age;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.age > 0) {
            generator.setContent(Integer.toString(this.age));
        }
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        try {
            this.age = Integer.parseInt(helper.consumeContent(true));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Age should be an integer");
        }
    }
}

