/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.test;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.oauth.OAuthInvalidateAccessTokenOn;
import org.mule.api.annotations.oauth.OAuthProtected;
import org.mule.modules.google.oauth.invalidation.OAuthTokenExpiredException;

public abstract class BaseGoogleConnectorTest<T>
extends TestCase {
    protected static final String pageToken = "blah";
    protected T connector;
    protected MuleMessage message;

    public void testOAuthProtected() {
        for (Method method : this.getConnectorClass().getMethods()) {
            if (method.getAnnotation(Processor.class) == null) continue;
            BaseGoogleConnectorTest.assertNotNull((String)"Not OAuth protected", (Object)method.getAnnotation(OAuthProtected.class));
            OAuthInvalidateAccessTokenOn inv = method.getAnnotation(OAuthInvalidateAccessTokenOn.class);
            BaseGoogleConnectorTest.assertNotNull((String)"No invalidation annotation", (Object)inv);
            BaseGoogleConnectorTest.assertEquals((Object)inv.exception(), OAuthTokenExpiredException.class);
        }
    }

    protected final void setUp() throws Exception {
        this.connector = this.getConnectorClass().newInstance();
        this.message = (MuleMessage)Mockito.mock(MuleMessage.class);
        this.doSetUp();
    }

    protected abstract void doSetUp();

    protected Class<T> getConnectorClass() {
        return (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    protected abstract String getNextPageTokenKey();

    protected void assertPagination() {
        ((MuleMessage)Mockito.verify((Object)this.message, (VerificationMode)Mockito.times((int)1))).setInvocationProperty((String)Mockito.eq((Object)this.getNextPageTokenKey()), Mockito.any());
    }
}

