/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.model;

import com.google.api.client.json.GenericJson;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseWrapper<T extends GenericJson> {
    protected T wrapped;

    public static <T extends BaseWrapper<?>, G extends GenericJson> List<T> valueOf(Collection<G> googles, Class<T> returnClass) {
        if (googles == null || googles.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(googles.size());
        try {
            Constructor<T> constructor = returnClass.getConstructor(((GenericJson)googles.iterator().next()).getClass());
            for (GenericJson google : googles) {
                result.add(constructor.newInstance(google));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not transform collection", e);
        }
        return result;
    }

    public static <G extends GenericJson, T extends BaseWrapper<?>> List<G> unwrapp(Collection<T> models, Class<G> returnClass) {
        if (models == null || models.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(models.size());
        for (BaseWrapper model : models) {
            result.add(model.wrapped());
        }
        return result;
    }

    public BaseWrapper(T wrapped) {
        if (wrapped == null) {
            Class clazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            try {
                wrapped = (GenericJson)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(String.format("null value passed at constructor but an instance of %s could not be created using default constructor", clazz.getCanonicalName()), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("null value passed at constructor but default constrcutor of %s doesn't seem public", clazz.getCanonicalName()), e);
            }
        }
        this.wrapped = wrapped;
    }

    public T wrapped() {
        return this.wrapped;
    }
}

