/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.client.batch;

import com.google.api.client.googleapis.json.GoogleJsonError;
import java.util.ArrayList;
import java.util.List;
import org.mule.common.bulk.BulkItem;
import org.mule.common.bulk.BulkOperationResult;

public class BatchResponse<T> {
    private List<T> successful = new ArrayList<T>();
    private List<GoogleJsonError.ErrorInfo> errors = new ArrayList<GoogleJsonError.ErrorInfo>();
    private BulkOperationResult.BulkOperationResultBuilder<T> resultBuilder = BulkOperationResult.builder();

    public BatchResponse<T> addSuccessful(T succesful) {
        this.successful.add(succesful);
        this.resultBuilder.addItem(BulkItem.builder().setPayload(succesful));
        return this;
    }

    public BatchResponse<T> addError(GoogleJsonError error) {
        this.errors.addAll(error.getErrors());
        this.resultBuilder.addItem(BulkItem.builder().setSuccessful(false).setStatusCode(String.valueOf(error.getCode())).setMessage(error.getMessage()));
        return this;
    }

    public List<T> getSuccessful() {
        return this.successful;
    }

    public List<GoogleJsonError.ErrorInfo> getErrors() {
        return this.errors;
    }

    public BulkOperationResult<T> asBulkOperationResult() {
        return this.resultBuilder.build();
    }
}

