/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.ICategory;
import com.google.gdata.util.common.base.CharEscapers;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Query {
    public static final int UNDEFINED = -1;
    private URL feedUrl;
    private List<CategoryFilter> categoryFilters = new LinkedList<CategoryFilter>();
    private String fields;
    private String queryString;
    private String author;
    private DateTime updatedMin;
    private DateTime updatedMax;
    private DateTime publishedMin;
    private DateTime publishedMax;
    private int startIndex = -1;
    private int maxResults = -1;
    private ResultFormat resultFormat = ResultFormat.DEFAULT;
    private boolean strict = false;
    private List<CustomParameter> customParameters = new ArrayList<CustomParameter>();

    public Query(URL feedUrl) {
        this.feedUrl = feedUrl;
    }

    public URL getFeedUrl() {
        return this.feedUrl;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFullTextQuery(String query) {
        this.queryString = query;
    }

    public String getFullTextQuery() {
        return this.queryString;
    }

    public void addCategoryFilter(CategoryFilter categoryFilter) {
        this.categoryFilters.add(categoryFilter);
    }

    public List<CategoryFilter> getCategoryFilters() {
        return Collections.unmodifiableList(this.categoryFilters);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setUpdatedMin(DateTime updatedMin) {
        this.updatedMin = updatedMin;
    }

    public DateTime getUpdatedMin() {
        return this.updatedMin;
    }

    public void setUpdatedMax(DateTime updatedMax) {
        this.updatedMax = updatedMax;
    }

    public DateTime getUpdatedMax() {
        return this.updatedMax;
    }

    public void setPublishedMin(DateTime publishedMin) {
        this.publishedMin = publishedMin;
    }

    public DateTime getPublishedMin() {
        return this.publishedMin;
    }

    public void setPublishedMax(DateTime publishedMax) {
        this.publishedMax = publishedMax;
    }

    public DateTime getPublishedMax() {
        return this.publishedMax;
    }

    public void setStartIndex(int startIndex) {
        if (startIndex != -1 && startIndex < 1) {
            throw new IllegalArgumentException("Start index must be positive");
        }
        this.startIndex = startIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setMaxResults(int maxResults) {
        if (maxResults != -1 && maxResults < 0) {
            throw new IllegalArgumentException("Max results must be zero or larger");
        }
        this.maxResults = maxResults;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setResultFormat(ResultFormat resultFormat) {
        this.resultFormat = resultFormat;
    }

    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void addCustomParameter(CustomParameter customParameter) {
        if (customParameter == null) {
            throw new NullPointerException("Null custom parameter");
        }
        this.customParameters.add(customParameter);
    }

    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    public List<CustomParameter> getCustomParameters(String name) {
        ArrayList<CustomParameter> matchList = new ArrayList<CustomParameter>();
        for (CustomParameter param : this.customParameters) {
            if (!param.name.equals(name)) continue;
            matchList.add(param);
        }
        return matchList;
    }

    protected void appendQueryParameter(StringBuilder queryBuf, String paramName, String paramValue) throws UnsupportedEncodingException {
        queryBuf.append(queryBuf.length() != 0 ? (char)'&' : '?');
        queryBuf.append(paramName);
        queryBuf.append("=");
        queryBuf.append(paramValue);
    }

    public boolean isValidState() {
        return this.resultFormat != ResultFormat.JSON_XD;
    }

    public URI getQueryUri() {
        if (!this.isValidState()) {
            throw new IllegalStateException("Unsupported Query");
        }
        StringBuilder pathBuf = new StringBuilder();
        try {
            if (this.categoryFilters.size() != 0) {
                pathBuf.append("-");
                for (CategoryFilter categoryFilter : this.categoryFilters) {
                    pathBuf.append("/");
                    pathBuf.append(CharEscapers.uriEscaper().escape(categoryFilter.toString()));
                }
            }
            StringBuilder queryBuf = new StringBuilder();
            if (this.queryString != null) {
                this.appendQueryParameter(queryBuf, "q", CharEscapers.uriEscaper().escape(this.queryString));
            }
            if (this.author != null) {
                this.appendQueryParameter(queryBuf, "author", CharEscapers.uriEscaper().escape(this.author));
            }
            if (this.resultFormat != ResultFormat.DEFAULT) {
                this.appendQueryParameter(queryBuf, "alt", this.resultFormat.paramValue());
            }
            if (this.updatedMin != null) {
                this.appendQueryParameter(queryBuf, "updated-min", CharEscapers.uriEscaper().escape(this.updatedMin.toString()));
            }
            if (this.updatedMax != null) {
                this.appendQueryParameter(queryBuf, "updated-max", CharEscapers.uriEscaper().escape(this.updatedMax.toString()));
            }
            if (this.publishedMin != null) {
                this.appendQueryParameter(queryBuf, "published-min", CharEscapers.uriEscaper().escape(this.publishedMin.toString()));
            }
            if (this.publishedMax != null) {
                this.appendQueryParameter(queryBuf, "published-max", CharEscapers.uriEscaper().escape(this.publishedMax.toString()));
            }
            if (this.startIndex != -1) {
                this.appendQueryParameter(queryBuf, "start-index", Integer.toString(this.startIndex));
            }
            if (this.maxResults != -1) {
                this.appendQueryParameter(queryBuf, "max-results", Integer.toString(this.maxResults));
            }
            if (this.fields != null) {
                this.appendQueryParameter(queryBuf, "fields", CharEscapers.uriEscaper().escape(this.fields));
            }
            if (this.strict) {
                this.appendQueryParameter(queryBuf, "strict", "true");
            }
            for (CustomParameter customParameter : this.customParameters) {
                this.appendQueryParameter(queryBuf, CharEscapers.uriEscaper().escape(customParameter.name), CharEscapers.uriEscaper().escape(customParameter.value));
            }
            return new URI(pathBuf.toString() + queryBuf.toString());
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("Unable to encode query URI", uee);
        }
        catch (URISyntaxException use) {
            throw new IllegalStateException("Unable to construct query URI", use);
        }
    }

    public URL getUrl() {
        try {
            String queryUri = this.getQueryUri().toString();
            if (queryUri.length() == 0) {
                return this.feedUrl;
            }
            String feedRoot = this.feedUrl.toString();
            StringBuilder urlBuf = new StringBuilder(feedRoot);
            if (!feedRoot.endsWith("/") && !queryUri.startsWith("?")) {
                urlBuf.append('/');
            }
            urlBuf.append(queryUri);
            return new URL(urlBuf.toString());
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException("Unable to create query URL", mue);
        }
    }

    public final void setStringCustomParameter(String name, String value) {
        List<CustomParameter> customParams = this.getCustomParameters();
        for (CustomParameter existingValue : this.getCustomParameters(name)) {
            customParams.remove(existingValue);
        }
        if (value != null) {
            customParams.add(new CustomParameter(name, value));
        }
    }

    public final String getStringCustomParameter(String name) {
        List<CustomParameter> params = this.getCustomParameters(name);
        if (params.size() == 0) {
            return null;
        }
        return params.get(0).getValue();
    }

    public final void setIntegerCustomParameter(String name, Integer value) {
        if (value == null) {
            this.setStringCustomParameter(name, null);
        } else {
            this.setStringCustomParameter(name, value.toString());
        }
    }

    public final Integer getIntegerCustomParameter(String name) {
        Integer intValue;
        String strValue = this.getStringCustomParameter(name);
        if (strValue != null) {
            try {
                intValue = Integer.parseInt(strValue);
            }
            catch (NumberFormatException nfe) {
                intValue = null;
            }
        } else {
            intValue = null;
        }
        return intValue;
    }

    public static class CustomParameter {
        private String name;
        private String value;

        public CustomParameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class CategoryFilter {
        private final List<ICategory> categories;
        private final List<ICategory> excludeCategories;

        public List<ICategory> getCategories() {
            return this.categories;
        }

        public List<ICategory> getExcludeCategories() {
            return this.excludeCategories;
        }

        public CategoryFilter() {
            this.categories = new LinkedList<ICategory>();
            this.excludeCategories = new LinkedList<ICategory>();
        }

        public CategoryFilter(List<ICategory> included, List<ICategory> excluded) {
            this.categories = included != null ? included : new LinkedList<ICategory>();
            this.excludeCategories = excluded != null ? excluded : new LinkedList<ICategory>();
        }

        public CategoryFilter(ICategory category) {
            this();
            this.categories.add(category);
        }

        public void addCategory(ICategory category) {
            this.categories.add(category);
        }

        public void addExcludeCategory(ICategory category) {
            this.excludeCategories.add(category);
        }

        private String getQueryString(ICategory category) {
            StringBuilder sb = new StringBuilder();
            String scheme = category.getScheme();
            if (scheme != null) {
                sb.append("{");
                sb.append(scheme);
                sb.append("}");
            }
            sb.append(category.getTerm());
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (ICategory category : this.categories) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("|");
                }
                sb.append(this.getQueryString(category));
            }
            for (ICategory category : this.excludeCategories) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append("|");
                }
                sb.append("-");
                sb.append(this.getQueryString(category));
            }
            return sb.toString();
        }
    }

    public static enum ResultFormat {
        DEFAULT("default"),
        ATOM("atom"),
        RSS("rss"),
        JSON("json"),
        JSONC("jsonc"),
        ATOM_IN_SCRIPT("atom-in-script"),
        RSS_IN_SCRIPT("rss-in-script"),
        JSON_IN_SCRIPT("json-in-script"),
        JSONC_IN_SCRIPT("jsonc-in-script"),
        JSON_XD("json-xd"),
        ATOM_SERVICE("atom-service");

        private String paramValue;

        private ResultFormat(String value) {
            this.paramValue = value;
        }

        public String paramValue() {
            return this.paramValue;
        }
    }
}

