/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="atom", nsUri="http://www.w3.org/2005/Atom", localName="link")
public class AnalyticsLink
extends Link {
    static final String XML_NAME = "link";
    private static final String TARGETKIND = "gd:targetKind";
    private String targetKind = null;

    public AnalyticsLink() {
    }

    public AnalyticsLink(String targetKind) {
        this.setTargetKind(targetKind);
        this.setImmutable(true);
    }

    public String getTargetKind() {
        return this.targetKind;
    }

    public void setTargetKind(String targetKind) {
        this.throwExceptionIfImmutable();
        this.targetKind = targetKind;
    }

    public boolean hasTargetKind() {
        return this.getTargetKind() != null;
    }

    @Override
    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(AnalyticsLink.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(TARGETKIND, this.targetKind);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.targetKind = helper.consume("targetKind", false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        AnalyticsLink other = (AnalyticsLink)obj;
        return AnalyticsLink.eq(this.targetKind, other.targetKind);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.targetKind != null) {
            result = 37 * result + this.targetKind.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{AnalyticsLink targetKind=" + this.targetKind + " " + super.toString() + "}";
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new AnalyticsLinkHandler(p);
    }

    class AnalyticsLinkHandler
    extends Link.AtomHandler {
        public AnalyticsLinkHandler(ExtensionProfile extProfile) {
            super(AnalyticsLink.this, extProfile, AnalyticsLink.class);
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            super.processAttribute(namespace, localName, value);
            if (namespace.equals("http://schemas.google.com/g/2005") && localName.equals("targetKind")) {
                AnalyticsLink.this.targetKind = value;
            }
        }
    }

    public static final class Rel {
        public static final String CHILD = "http://schemas.google.com/ga/2009#child";
        public static final String PARENT = "http://schemas.google.com/ga/2009#parent";
    }
}

