/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.appsforyourdomain.migration;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.appsforyourdomain.Namespaces;
import com.google.gdata.util.ParseException;

public class Rfc822Msg
extends ValueConstruct {
    public static final String EXTENSION_LOCAL_NAME = "rfc822Msg";
    public static final String ATTRIBUTE_ENCODING = "encoding";
    private Encoding encoding;
    private static ExtensionDescription EXTENSION_DESC = new ExtensionDescription();

    public Rfc822Msg() {
        this(null, Encoding.NONE);
    }

    public Rfc822Msg(String msg) {
        this(msg, Encoding.NONE);
    }

    public Rfc822Msg(String msg, Encoding encoding) {
        super(Namespaces.APPS_NAMESPACE, EXTENSION_LOCAL_NAME, null, msg);
        if (encoding == null) {
            throw new IllegalArgumentException("Encoding may not be null.  Use Encoding.NONE to specify no encoding.");
        }
        this.encoding = encoding;
    }

    public String getMsg() {
        return this.getValue();
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        String enc = helper.consume(ATTRIBUTE_ENCODING, false);
        this.encoding = enc != null ? Encoding.valueOf(enc.toUpperCase()) : Encoding.NONE;
    }

    @Override
    public void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.encoding != Encoding.NONE) {
            generator.put(ATTRIBUTE_ENCODING, this.encoding.name().toLowerCase());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.encoding.hashCode() + (this.getMsg() == null ? 0 : this.getMsg().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Rfc822Msg)) {
            return false;
        }
        Rfc822Msg other = (Rfc822Msg)obj;
        if (this.getMsg() == null ? other.getMsg() != null : !this.getMsg().equals(other.getMsg())) {
            return false;
        }
        return this.encoding.equals((Object)other.encoding);
    }

    public static ExtensionDescription getDefaultDescription() {
        return EXTENSION_DESC;
    }

    static {
        EXTENSION_DESC.setExtensionClass(Rfc822Msg.class);
        EXTENSION_DESC.setNamespace(Namespaces.APPS_NAMESPACE);
        EXTENSION_DESC.setLocalName(EXTENSION_LOCAL_NAME);
        EXTENSION_DESC.setRepeatable(false);
    }

    public static enum Encoding {
        NONE,
        BASE64;

    }
}

