/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.calendar;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gCal", nsUri="http://schemas.google.com/gCal/2005", localName="resource")
public class ResourceProperty
extends AbstractExtension {
    static final String EXTENSION_LOCAL_NAME = "resource";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_VALUE = "value";
    public static final ResourceProperty TRUE = new ResourceProperty("true");
    public static final ResourceProperty FALSE = new ResourceProperty("false");
    protected String id;
    protected String value;

    public static ExtensionDescription getDefaultDescription() {
        return ExtensionDescription.getDefaultDescription(ResourceProperty.class);
    }

    public ResourceProperty() {
        this(null);
    }

    public ResourceProperty(String value) {
        this.value = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String resId) {
        this.id = resId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(ATTRIBUTE_ID, this.id);
        generator.put(ATTRIBUTE_VALUE, this.value);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.id = helper.consume(ATTRIBUTE_ID, false);
        this.value = helper.consume(ATTRIBUTE_VALUE, false);
    }

    @Override
    protected void validate() {
        if (this.id == null && this.value == null) {
            throw new IllegalStateException("No attributes defined");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        ResourceProperty prop = (ResourceProperty)o;
        return ResourceProperty.eq(this.value, prop.value) && ResourceProperty.eq(this.id, prop.id);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        if (this.id != null) {
            result = 37 * result + this.id.hashCode();
        }
        return result;
    }
}

