/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.modules.google.oauth.invalidation.OAuthTokenExpiredException;

public class AuthenticationException
extends ServiceException {
    private static final long serialVersionUID = -6345720441624559711L;
    private String authHeader;
    private String scheme;
    private Map<String, String> parameters = new HashMap<String, String>();
    private static final Pattern SCHEME_PATTERN = Pattern.compile("([^\\s$]*)\\s*(.*)?");
    private static String TOKEN = "[\\p{ASCII}&&[^\\p{Cntrl} \t;/=\\[\\]\\(\\)\\<\\>\\@\\,\\:\\\"\\?\\=]]+";
    private static final Pattern PARAM_PATTERN = Pattern.compile("(" + TOKEN + ")" + "\\s*=\\s*" + "(?:" + "\"([^\"]*)\"" + "|" + "(" + TOKEN + ")?" + ")");

    public AuthenticationException(String message, String authHeader) {
        super(message);
        this.initFromAuthHeader(authHeader);
    }

    public AuthenticationException(String message) {
        super(message);
    }

    public AuthenticationException(HttpURLConnection httpConn) throws IOException {
        super(httpConn);
        this.initFromAuthHeader(httpConn.getHeaderField("WWW-Authenticate"));
    }

    private void initFromAuthHeader(String authHeader) {
        this.authHeader = authHeader;
        if (authHeader == null) {
            throw new OAuthTokenExpiredException("No authentication header information");
        }
        Matcher authMatcher = SCHEME_PATTERN.matcher(authHeader);
        if (!authMatcher.matches()) {
            throw new IllegalStateException("Unable to parse auth header: " + authHeader);
        }
        this.scheme = authMatcher.group(1);
        if (authMatcher.groupCount() > 1) {
            Matcher paramMatcher = PARAM_PATTERN.matcher(authMatcher.group(2));
            while (paramMatcher.find()) {
                String value = paramMatcher.group(2);
                if (value == null) {
                    value = paramMatcher.group(3);
                }
                this.parameters.put(paramMatcher.group(1), value);
            }
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRealm() {
        return this.parameters.get("realm");
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getAuthHeader() {
        return this.authHeader;
    }
}

