/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;

public class Shipping {
    private final String country;
    private final Collection<String> regions;
    private final String service;
    private final float price;
    private final String currency;

    public Shipping(String country, String service, float price, String currency) {
        this(country, null, service, price, currency);
    }

    public Shipping(String country, Collection<String> regions, String service, float price, String currency) {
        this.country = country;
        this.regions = regions != null ? ImmutableList.copyOf(regions) : Collections.emptySet();
        this.price = price;
        this.service = service;
        this.currency = currency;
    }

    public String toString() {
        return "Shipping(country=" + this.country + ", regions=" + this.regions + ", service=" + this.service + ", price= " + this.price + ", currency=" + this.currency + ")";
    }

    public float getPrice() {
        return this.price;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCountry() {
        return this.country;
    }

    public Collection<String> getRegions() {
        return this.regions;
    }

    public String getService() {
        return this.service;
    }
}

