/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.sidewiki;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="sidewiki", nsUri="http://schemas.google.com/sidewiki/2009", localName="source")
public class Source
extends AbstractExtension {
    static final String XML_NAME = "source";
    private static final AttributeHelper.EnumToAttributeValue<Value> VALUE_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.LowerCaseEnumToAttributeValue<Value>();
    private Value value = null;

    public Source() {
    }

    public Source(Value value) {
        this.setValue(value);
        this.setImmutable(true);
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Source.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.setContent(VALUE_ENUM_TO_ATTRIBUTE_VALUE.getAttributeValue(this.value));
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.value = helper.consumeEnum(null, true, Value.class, null, VALUE_ENUM_TO_ATTRIBUTE_VALUE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Source other = (Source)obj;
        return Source.eq((Object)this.value, (Object)other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Source value=" + (Object)((Object)this.value) + "}";
    }

    public static enum Value {
        BLOG,
        SIDEWIKI;

    }
}

