/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gs", nsUri="http://schemas.google.com/spreadsheets/2006", localName="column")
public class Column
extends ExtensionPoint {
    static final String XML_NAME = "column";
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private String index = null;
    private String name = null;

    public Column() {
    }

    public Column(String index, String name) {
        this.setIndex(index);
        this.setName(name);
        this.setImmutable(true);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.throwExceptionIfImmutable();
        this.index = index;
    }

    public boolean hasIndex() {
        return this.getIndex() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    @Override
    protected void validate() {
        if (this.index == null) {
            Column.throwExceptionForMissingAttribute(INDEX);
        }
        if (this.name == null) {
            Column.throwExceptionForMissingAttribute(NAME);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Column.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(INDEX, this.index);
        generator.put(NAME, this.name);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.index = helper.consume(INDEX, true);
        this.name = helper.consume(NAME, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Column other = (Column)obj;
        return Column.eq(this.index, other.index) && Column.eq(this.name, other.name);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.index != null) {
            result = 37 * result + this.index.hashCode();
        }
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Column index=" + this.index + " name=" + this.name + "}";
    }
}

