/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.GDataProtocol;
import com.google.gdata.client.Service;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.Category;
import com.google.gdata.data.Content;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.Person;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.PubControl;
import com.google.gdata.data.Reference;
import com.google.gdata.data.Rfc3339Handler;
import com.google.gdata.data.Source;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.data.XmlEventSource;
import com.google.gdata.data.batch.BatchInterrupted;
import com.google.gdata.data.batch.BatchStatus;
import com.google.gdata.util.EventSourceParser;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ParseUtil;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;

public abstract class BaseEntry<E extends BaseEntry>
extends ExtensionPoint
implements Kind.Adaptable,
Kind.Adaptor,
IEntry {
    protected EntryState state;
    private XmlNamespace atomPubNs;
    private final transient String etag;
    private final transient String rights;
    private final transient List<Link> links = null;
    private final transient List<Person> contributors = null;
    private final transient Source source = null;
    private final transient Service service = null;
    private final transient Collection<Kind.Adaptor> adaptors = null;
    private final transient Link selfLink = null;
    private final transient Link editLink = null;
    private final transient Link mediaEditLink = null;
    private final transient Link resumableEditMediaLink = null;
    private final transient Link htmlLink = null;
    private final transient E self = null;
    private static final Collection<XmlNamespace> namespaceDeclsAtom = new Vector<XmlNamespace>(1);
    private static final Collection<XmlNamespace> namespaceDeclsRss = new Vector<XmlNamespace>(1);
    private transient BaseEntry<?> adaptedEntry;

    protected BaseEntry() {
        this.etag = null;
        this.rights = null;
        this.state = new EntryState();
    }

    private XmlNamespace getAtomPubNs() {
        if (this.atomPubNs == null) {
            this.atomPubNs = Namespaces.getAtomPubNs();
        }
        return this.atomPubNs;
    }

    protected BaseEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
        this.etag = null;
        this.rights = null;
        this.state = sourceEntry.state;
    }

    @Override
    public String getId() {
        return this.state.id;
    }

    @Override
    public void setId(String v) {
        if (v != null && "-".equals(v)) {
            throw new IllegalArgumentException("Entry.id must not be equal to '-'.");
        }
        this.state.id = v;
    }

    @Override
    public String getVersionId() {
        return this.state.versionId;
    }

    @Override
    public void setVersionId(String v) {
        this.state.versionId = v;
    }

    @Override
    public String getEtag() {
        return this.state.etag;
    }

    @Override
    public void setEtag(String v) {
        this.state.etag = v;
    }

    @Override
    public String getSelectedFields() {
        return this.state.fields;
    }

    @Override
    public void setSelectedFields(String v) {
        this.state.fields = v;
    }

    @Override
    public String getKind() {
        return this.state.kind;
    }

    @Override
    public void setKind(String v) {
        this.state.kind = v;
    }

    @Override
    public DateTime getPublished() {
        return this.state.published;
    }

    @Override
    public void setPublished(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.published must have a timezone.");
        }
        this.state.published = v;
    }

    @Override
    public DateTime getUpdated() {
        return this.state.updated;
    }

    @Override
    public void setUpdated(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.updated must have a timezone.");
        }
        this.state.updated = v;
    }

    @Override
    public DateTime getEdited() {
        return this.state.edited;
    }

    @Override
    public void setEdited(DateTime v) {
        if (v != null && v.getTzShift() == null) {
            throw new IllegalArgumentException("Entry.edited must have a timezone.");
        }
        this.state.edited = v;
    }

    public Set<Category> getCategories() {
        return this.state.categories;
    }

    @Override
    public TextConstruct getTitle() {
        return this.state.title;
    }

    public void setTitle(TextConstruct v) {
        this.state.title = v;
    }

    @Override
    public TextConstruct getSummary() {
        return this.state.summary;
    }

    public void setSummary(TextConstruct v) {
        this.state.summary = v;
    }

    public TextConstruct getRights() {
        return this.state.rights;
    }

    public void setRights(TextConstruct v) {
        this.state.rights = v;
    }

    @Override
    public Content getContent() {
        return this.state.content;
    }

    public void setContent(Content v) {
        this.state.content = v;
    }

    public TextContent getTextContent() {
        Content content = this.getContent();
        if (content == null) {
            content = new TextContent(new PlainTextConstruct());
        }
        if (!(content instanceof TextContent)) {
            throw new IllegalStateException("Content object is not a TextContent : " + content);
        }
        return (TextContent)content;
    }

    public String getPlainTextContent() {
        TextConstruct textConstruct = this.getTextContent().getContent();
        if (!(textConstruct instanceof PlainTextConstruct)) {
            throw new IllegalStateException("TextConstruct object is not a PlainTextConstruct");
        }
        return textConstruct.getPlainText();
    }

    public void setContent(TextConstruct tc) {
        this.state.content = new TextContent(tc);
    }

    public List<Link> getLinks() {
        return this.state.links;
    }

    public void addLink(Link link) {
        this.state.links.add(link);
    }

    @Override
    public Link addLink(String rel, String type, String href) {
        Link link = new Link(rel, type, href);
        this.addLink(link);
        return link;
    }

    public List<Person> getAuthors() {
        return this.state.authors;
    }

    public List<Person> getContributors() {
        return this.state.contributors;
    }

    public Source getSource() {
        return this.state.source;
    }

    public void setSource(Source v) {
        this.state.source = v;
    }

    public void setDraft(Boolean v) {
        if (this.state.pubControl == null) {
            if (!Boolean.TRUE.equals(v)) {
                return;
            }
            this.state.pubControl = new PubControl();
        }
        this.state.pubControl.setDraft(v);
    }

    public boolean isDraft() {
        return this.state.pubControl != null ? this.state.pubControl.isDraft() : false;
    }

    public PubControl getPubControl() {
        return this.state.pubControl;
    }

    public void setPubControl(PubControl value) {
        this.state.pubControl = value;
    }

    @Override
    public void setService(Service s) {
        this.state.service = s;
    }

    public Service getService() {
        return this.state.service;
    }

    @Override
    public boolean getCanEdit() {
        return this.state.canEdit;
    }

    @Override
    public void setCanEdit(boolean v) {
        this.state.canEdit = v;
    }

    @Override
    public void addAdaptor(Kind.Adaptor adaptor) {
        this.state.adaptable.addAdaptor(adaptor);
    }

    @Override
    public Collection<Kind.Adaptor> getAdaptors() {
        return this.state.adaptable.getAdaptors();
    }

    public <A extends Kind.Adaptor> A getAdaptor(Class<A> adaptorClass) {
        return this.state.adaptable.getAdaptor(adaptorClass);
    }

    @Override
    public Link getLink(String rel, String type) {
        for (Link link : this.state.links) {
            if (!link.matches(rel, type)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getLinks(String relToMatch, String typeToMatch) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.state.links) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void removeLinks(String relToMatch, String typeToMatch) {
        Iterator iterator = this.state.links.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (!link.matches(relToMatch, typeToMatch)) continue;
            iterator.remove();
        }
    }

    @Override
    public void removeLinks() {
        this.state.links.clear();
    }

    public void addHtmlLink(String htmlUri, String lang, String title) {
        Link link = new Link();
        link.setRel("alternate");
        link.setType(ILink.Type.HTML);
        link.setHref(htmlUri);
        if (lang != null) {
            link.setHrefLang(lang);
        }
        if (title != null) {
            link.setTitle(title);
        }
        this.state.links.add(link);
    }

    @Override
    public Link getSelfLink() {
        Link selfLink = this.getLink("self", ILink.Type.ATOM);
        return selfLink;
    }

    @Override
    public Link getEditLink() {
        Link editLink = this.getLink("edit", ILink.Type.ATOM);
        return editLink;
    }

    @Override
    public Link getMediaEditLink() {
        Link mediaLink = this.getLink("edit-media", null);
        if (mediaLink == null) {
            mediaLink = this.getLink("media-edit", null);
        }
        return mediaLink;
    }

    @Override
    public Link getResumableEditMediaLink() {
        return this.getLink("http://schemas.google.com/g/2005#resumable-edit-media", null);
    }

    public Link getHtmlLink() {
        Link htmlLink = this.getLink("alternate", ILink.Type.HTML);
        return htmlLink;
    }

    public E getSelf() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link selfLink = this.getSelfLink();
        if (selfLink == null) {
            throw new UnsupportedOperationException("Entry cannot be retrieved");
        }
        URL entryUrl = new URL(selfLink.getHref());
        try {
            if (this.state.etag != null) {
                return (E)((BaseEntry)this.state.service.getEntry(entryUrl, this.getClass(), this.state.etag));
            }
            return (E)((BaseEntry)this.state.service.getEntry(entryUrl, this.getClass(), this.state.edited != null ? this.state.edited : this.state.updated));
        }
        catch (NotModifiedException e) {
            return (E)this;
        }
    }

    public E update() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link editLink = this.getEditLink();
        if (editLink == null) {
            throw new UnsupportedOperationException("Entry cannot be updated");
        }
        URL editUrl = new URL(editLink.getHref());
        return (E)this.state.service.update(editUrl, this);
    }

    public void delete() throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link editLink = this.getEditLink();
        if (editLink == null) {
            throw new UnsupportedOperationException("Entry cannot be deleted");
        }
        URL editUrl = new URL(editLink.getHref());
        this.state.service.delete(editUrl, GDataProtocol.isWeakEtag(this.state.etag) ? null : this.state.etag);
    }

    @Override
    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        if (this.state.content instanceof OutOfLineContent) {
            this.visitChild(ev, new OutOfLineReference((OutOfLineContent)this.state.content));
        }
        for (Link link : this.getLinks()) {
            this.visitChild(ev, link);
        }
        super.visitChildren(ev);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        this.generateAtom(w, p);
    }

    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        LinkedHashSet<XmlNamespace> nsDecls = new LinkedHashSet<XmlNamespace>(namespaceDeclsAtom);
        nsDecls.addAll(extProfile.getNamespaceDecls());
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.state.kind != null && Service.getVersion().isAfter(Service.Versions.V1)) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "kind", this.state.kind));
        }
        if (this.state.etag != null && !Service.getVersion().isCompatible(Service.Versions.V1)) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "etag", this.state.etag));
        }
        if (this.state.fields != null && Service.getVersion().isAfter(Service.Versions.V1)) {
            nsDecls.add(Namespaces.gNs);
            attrs.add(new XmlWriter.Attribute("gd", "fields", this.state.fields));
        }
        AttributeGenerator generator = new AttributeGenerator();
        this.putAttributes(generator);
        this.generateAttributes(attrs, generator);
        this.generateStartElement(w, Namespaces.atomNs, "entry", attrs, nsDecls);
        if (this.state.id != null) {
            w.simpleElement(Namespaces.atomNs, "id", null, this.state.id);
        }
        if (this.state.published != null) {
            w.simpleElement(Namespaces.atomNs, "published", null, this.state.published.toString());
        }
        if (this.state.updated != null) {
            w.simpleElement(Namespaces.atomNs, "updated", null, this.state.updated.toString());
        }
        if (this.state.edited != null) {
            w.simpleElement(this.getAtomPubNs(), "edited", null, this.state.edited.toString());
        }
        if (this.state.pubControl != null) {
            this.state.pubControl.generateAtom(w, extProfile);
        }
        w.startRepeatingElement();
        for (Category cat : this.state.categories) {
            cat.generateAtom(w);
        }
        w.endRepeatingElement();
        if (this.state.title != null) {
            this.state.title.generateAtom(w, "title");
        }
        if (this.state.summary != null) {
            this.state.summary.generateAtom(w, "summary");
        }
        if (this.state.rights != null) {
            this.state.rights.generateAtom(w, "rights");
        }
        if (this.state.content != null) {
            this.state.content.generateAtom(w, extProfile);
        }
        w.startRepeatingElement();
        for (Link link : this.state.links) {
            link.generateAtom(w, extProfile);
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person author : this.state.authors) {
            author.generateAtom(extProfile, w, "author");
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person contributor : this.state.contributors) {
            contributor.generateAtom(extProfile, w, "contributor");
        }
        w.endRepeatingElement();
        if (this.state.source != null) {
            this.state.source.generateAtom(w, extProfile);
        }
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.atomNs, "entry");
    }

    public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        Vector<XmlNamespace> nsDecls = new Vector<XmlNamespace>(namespaceDeclsRss);
        nsDecls.addAll(extProfile.getNamespaceDecls());
        this.generateStartElement(w, Namespaces.rssNs, "item", null, nsDecls);
        if (this.state.id != null) {
            ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(1);
            attrs.add(new XmlWriter.Attribute("isPermaLink", "false"));
            w.simpleElement(Namespaces.rssNs, "guid", attrs, this.state.id);
        }
        String lang = null;
        if (this.state.content != null) {
            lang = this.state.content.getLang();
        }
        if (lang == null && this.state.summary != null) {
            lang = this.state.summary.getLang();
        }
        if (lang == null && this.state.title != null) {
            lang = this.state.title.getLang();
        }
        if (lang != null) {
            w.simpleElement(Namespaces.rssNs, "language", null, lang);
        }
        if (this.state.published != null) {
            w.simpleElement(Namespaces.rssNs, "pubDate", null, this.state.published.toStringRfc822());
        }
        if (this.state.updated != null) {
            w.simpleElement(Namespaces.atomNs, "updated", null, this.state.updated.toString());
        }
        w.startRepeatingElement();
        for (Category cat : this.state.categories) {
            cat.generateRss(w);
        }
        w.endRepeatingElement();
        if (this.state.title != null) {
            this.state.title.generateRss(w, "title", TextConstruct.RssFormat.PLAIN_TEXT);
        }
        if (this.state.summary != null) {
            this.state.summary.generateAtom(w, "summary");
        }
        if (this.state.content != null) {
            this.state.content.generateRss(w, extProfile);
        }
        w.startRepeatingElement();
        for (Link link : this.state.links) {
            link.generateRss(w);
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person author : this.state.authors) {
            author.generateRss(w, "author");
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person contributor : this.state.contributors) {
            contributor.generateRss(w, "author");
        }
        w.endRepeatingElement();
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.rssNs, "item");
    }

    public static BaseEntry<?> readEntry(ParseSource source) throws IOException, ParseException, ServiceException {
        return BaseEntry.readEntry(source, null, null);
    }

    public static <T extends BaseEntry> T readEntry(ParseSource source, Class<T> entryClass, ExtensionProfile extProfile) throws IOException, ParseException, ServiceException {
        return (T)((BaseEntry)ParseUtil.readEntry(source, entryClass, extProfile, null));
    }

    public void parseAtom(ExtensionProfile extProfile, InputStream input) throws IOException, ParseException {
        AtomHandler handler = new AtomHandler(extProfile);
        new XmlParser().parse(input, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "entry");
    }

    public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
        AtomHandler handler = new AtomHandler(extProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "entry");
    }

    public void parseAtom(ExtensionProfile extProfile, XmlEventSource eventSource) throws IOException, ParseException {
        AtomHandler handler = new AtomHandler(extProfile);
        new EventSourceParser(handler, "http://www.w3.org/2005/Atom", "entry").parse(eventSource);
    }

    protected Content.ChildHandlerInfo getContentHandlerInfo(ExtensionProfile extProfile, Attributes attrs) throws ParseException, IOException {
        return Content.getChildHandler(extProfile, attrs);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new AtomHandler(p);
    }

    public BaseEntry<?> getAdaptedEntry() throws Kind.AdaptorException {
        Object adaptedEntry = null;
        for (Kind.Adaptor adaptor : this.getAdaptors()) {
            if (!(adaptor instanceof BaseEntry) || adaptedEntry != null && !adaptedEntry.getClass().isAssignableFrom(adaptor.getClass())) continue;
            adaptedEntry = (BaseEntry)adaptor;
        }
        return adaptedEntry;
    }

    static {
        namespaceDeclsAtom.add(Namespaces.atomNs);
        namespaceDeclsRss.add(Namespaces.atomNs);
    }

    public class AtomHandler
    extends ExtensionPoint.ExtensionHandler {
        public AtomHandler(ExtensionProfile extProfile) {
            super(BaseEntry.this, extProfile, BaseEntry.this.getClass());
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("http://schemas.google.com/g/2005")) {
                if (localName.equals("etag")) {
                    BaseEntry.this.setEtag(value);
                    return;
                }
                if (localName.equals("fields")) {
                    BaseEntry.this.setSelectedFields(value);
                    return;
                }
                if (localName.equals("kind")) {
                    BaseEntry.this.setKind(value);
                    return;
                }
            }
            super.processAttribute(namespace, localName, value);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom")) {
                if (localName.equals("id")) {
                    return new IdHandler();
                }
                if (localName.equals("published")) {
                    return new PublishedHandler();
                }
                if (localName.equals("updated")) {
                    return new UpdatedHandler();
                }
                if (localName.equals("title")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (BaseEntry.this.state.title != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateTitle);
                    }
                    BaseEntry.this.state.title = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("summary")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (BaseEntry.this.state.summary != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateSummary);
                    }
                    BaseEntry.this.state.summary = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("rights")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (BaseEntry.this.state.rights != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateRights);
                    }
                    BaseEntry.this.state.rights = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("content")) {
                    if (BaseEntry.this.state.content != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateContent);
                    }
                    Content.ChildHandlerInfo chi = BaseEntry.this.getContentHandlerInfo(this.extProfile, attrs);
                    BaseEntry.this.state.content = chi.content;
                    return chi.handler;
                }
                if (localName.equals("category")) {
                    Category cat;
                    Category category = cat = new Category();
                    category.getClass();
                    return new Category.AtomHandler(category, this.extProfile, BaseEntry.this.state.categories, BaseEntry.this);
                }
                if (localName.equals("link")) {
                    Link link = new Link();
                    BaseEntry.this.state.links.add(link);
                    Link link2 = link;
                    link2.getClass();
                    return new Link.AtomHandler(link2, this.extProfile);
                }
                if (localName.equals("author")) {
                    ExtensionDescription extDescription = BaseEntry.this.getExtensionDescription(this.extProfile, this.extendedClass, namespace, localName);
                    Person author = extDescription != null && extDescription.getExtensionClass() != null ? (Person)ExtensionPoint.createExtensionInstance(extDescription.getExtensionClass()) : new Person();
                    BaseEntry.this.state.authors.add(author);
                    return author.getHandler(this.extProfile, namespace, localName, attrs);
                }
                if (localName.equals("contributor")) {
                    Person contributor = new Person();
                    BaseEntry.this.state.contributors.add(contributor);
                    Person person = contributor;
                    person.getClass();
                    return new Person.AtomHandler(person, this.extProfile);
                }
                if (localName.equals("source")) {
                    Source source = BaseEntry.this.state.source = new Source();
                    source.getClass();
                    return new Source.SourceHandler(source, this.extProfile);
                }
            } else if (namespace.equals(BaseEntry.this.getAtomPubNs().getUri())) {
                if (localName.equals("control")) {
                    PubControl pubControl = BaseEntry.this.state.pubControl = new PubControl();
                    pubControl.getClass();
                    return new PubControl.AtomHandler(pubControl, this.extProfile);
                }
                if (localName.equals("edited")) {
                    return new EditedHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }

        @Override
        public void processEndElement() throws ParseException {
            if (BaseEntry.this.getExtension(BatchStatus.class) == null && BaseEntry.this.getExtension(BatchInterrupted.class) == null) {
                super.processEndElement();
            }
        }

        class EditedHandler
        extends Rfc3339Handler {
            EditedHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                super.processEndElement();
                BaseEntry.this.state.edited = this.getDateTime();
            }
        }

        class UpdatedHandler
        extends Rfc3339Handler {
            UpdatedHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                super.processEndElement();
                BaseEntry.this.state.updated = this.getDateTime();
            }
        }

        class PublishedHandler
        extends Rfc3339Handler {
            PublishedHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                super.processEndElement();
                BaseEntry.this.state.published = this.getDateTime();
            }
        }

        class IdHandler
        extends XmlParser.ElementHandler {
            IdHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                if (BaseEntry.this.state.id != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateEntryId);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.idValueRequired);
                }
                BaseEntry.this.state.id = this.value;
            }
        }
    }

    private class OutOfLineReference
    implements Reference,
    Extension {
        private OutOfLineContent oolContent;

        private OutOfLineReference(OutOfLineContent oolContent) {
            this.oolContent = oolContent;
        }

        @Override
        public String getHref() {
            return this.oolContent.getUri();
        }

        @Override
        public void setHref(String href) {
            this.oolContent.setUri(href);
        }

        @Override
        public void generate(XmlWriter w, ExtensionProfile extProfile) {
            throw new IllegalStateException("Should not be generated");
        }

        @Override
        public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
            throw new IllegalStateException("Should not be parsed");
        }
    }

    protected static class EntryState {
        public String id;
        public String versionId;
        public String etag;
        public String fields;
        public String kind;
        public DateTime published;
        public DateTime updated;
        public DateTime edited;
        public HashSet<Category> categories = new HashSet();
        public TextConstruct title;
        public TextConstruct summary;
        public TextConstruct rights;
        public Content content;
        public LinkedList<Link> links = new LinkedList();
        public LinkedList<Person> authors = new LinkedList();
        public LinkedList<Person> contributors = new LinkedList();
        public Source source;
        public Service service;
        public boolean canEdit = true;
        public PubControl pubControl;
        public Kind.Adaptable adaptable = new Kind.AdaptableHelper();

        protected EntryState() {
        }
    }
}

