/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.appsforyourdomain.migration;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ContentType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class Rfc822MediaSource
implements MediaSource {
    private final String rfc822Msg;

    public Rfc822MediaSource(String rfc822Msg) {
        if (rfc822Msg == null || "".equals(rfc822Msg)) {
            throw new IllegalArgumentException("Empty or null message");
        }
        this.rfc822Msg = rfc822Msg;
    }

    @Override
    public long getContentLength() {
        return this.rfc822Msg.length();
    }

    @Override
    public String getEtag() {
        return null;
    }

    @Override
    public DateTime getLastModified() {
        return null;
    }

    public String getContentType() {
        return ContentType.MESSAGE_RFC822.toString();
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.rfc822Msg.getBytes());
    }

    public String getName() {
        return "rfc822";
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException();
    }
}

