/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.batch.IBatchStatus;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class BatchStatus
extends ExtensionPoint
implements Extension,
IBatchStatus {
    private int code;
    private String reason;
    private transient ContentType contentType;
    private String content;

    public BatchStatus() {
    }

    public BatchStatus(ServiceException e) {
        this.code = e.getHttpErrorCodeOverride();
        if (this.code == -1) {
            this.code = 500;
        }
        this.reason = e.getMessage();
        this.contentType = e.getResponseContentType();
        this.content = e.getResponseBody();
    }

    public static BatchStatus createSuccessStatus() {
        BatchStatus retval = new BatchStatus();
        retval.setCode(200);
        retval.setReason("Success");
        return retval;
    }

    public static BatchStatus createCreatedStatus() {
        BatchStatus retval = new BatchStatus();
        retval.setCode(201);
        retval.setReason("Created");
        return retval;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(BatchStatus.class);
        desc.setNamespace(Namespaces.batchNs);
        desc.setLocalName("status");
        desc.setRepeatable(false);
        return desc;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attributes = new ArrayList<XmlWriter.Attribute>(4);
        if (this.code > 0) {
            attributes.add(new XmlWriter.Attribute("code", Integer.toString(this.code)));
        }
        if (this.reason != null) {
            attributes.add(new XmlWriter.Attribute("reason", this.reason));
        }
        if (this.contentType != null) {
            this.contentType.getAttributes().remove("charset");
            attributes.add(new XmlWriter.Attribute("content-type", this.contentType.toString()));
        }
        this.generateStartElement(w, Namespaces.batchNs, "status", attributes, null);
        this.generateExtensions(w, extProfile);
        if (this.content != null) {
            w.characters(this.content);
        }
        w.endElement(Namespaces.batchNs, "status");
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException {
        return new BatchStatusElementHandler(extProfile, attrs);
    }

    private class BatchStatusElementHandler
    extends ExtensionPoint.ExtensionHandler {
        private BatchStatusElementHandler(ExtensionProfile extProfile, Attributes attrs) throws ParseException {
            String contentType;
            String reason;
            super(BatchStatus.this, extProfile, BatchStatus.class);
            String code = attrs.getValue("code");
            if (code != null) {
                try {
                    BatchStatus.this.setCode(Integer.parseInt(code));
                }
                catch (NumberFormatException e) {
                    ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidIntegerAttribute, (Throwable)e);
                    pe.setInternalReason("Invalid integer value for code attribute : '" + code + "'");
                    throw pe;
                }
            }
            if ((reason = attrs.getValue("reason")) != null) {
                BatchStatus.this.setReason(reason);
            }
            if ((contentType = attrs.getValue("content-type")) != null) {
                try {
                    BatchStatus.this.setContentType(new ContentType(contentType));
                }
                catch (IllegalArgumentException e) {
                    ParseException pe = new ParseException(CoreErrorDomain.ERR.invalidContentType, (Throwable)e);
                    pe.setInternalReason("Invalid content type: " + contentType);
                    throw pe;
                }
            }
        }

        @Override
        public void processEndElement() {
            if (this.value != null) {
                BatchStatus.this.setContent(this.value);
            }
        }
    }
}

