/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="country")
public class Country
extends AbstractExtension {
    static final String XML_NAME = "country";
    private static final String CODE = "code";
    private String code = null;
    private String value = null;

    public Country() {
    }

    public Country(String code, String value) {
        this.setCode(code);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.throwExceptionIfImmutable();
        this.code = code;
    }

    public boolean hasCode() {
        return this.getCode() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Country.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(CODE, this.code);
        generator.setContent(this.value);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.code = helper.consume(CODE, false);
        this.value = helper.consume(null, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Country other = (Country)obj;
        return Country.eq(this.code, other.code) && Country.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.code != null) {
            result = 37 * result + this.code.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Country code=" + this.code + " value=" + this.value + "}";
    }
}

