/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;

public abstract class BoolValueConstruct
extends ValueConstruct {
    private boolean boolValue;

    public BoolValueConstruct(String nodeName) {
        super(Namespaces.WT_NAMESPACE, nodeName, null);
        this.setBooleanValue(false);
    }

    @Override
    public boolean equals(Object rhs) {
        if (!super.equals(rhs)) {
            return false;
        }
        BoolValueConstruct r = (BoolValueConstruct)rhs;
        return this.boolValue == r.boolValue;
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("value can not be null");
        }
        if ("true".equals(value) || "1".equals(value)) {
            this.setBooleanValue(true);
        } else if ("false".equals(value) || "0".equals(value)) {
            this.setBooleanValue(false);
        } else {
            throw new IllegalArgumentException("Invalid boolean value: " + value);
        }
    }

    public void setBooleanValue(boolean value) {
        this.boolValue = value;
        super.setValue(String.valueOf(value));
    }

    public boolean getBooleanValue() {
        return this.boolValue;
    }
}

