/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.GoogleBaseAttributeId;
import com.google.api.gbase.client.GoogleBaseAttributeType;
import com.google.api.gbase.client.GoogleBaseNamespaces;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="gm", nsUri="http://base.google.com/ns-metadata/1.0", localName="attributes")
public class GmAttributes
implements Extension {
    private final List<GmAttribute> attributes = new ArrayList<GmAttribute>();
    private final Set<GoogleBaseAttributeId> attributeIds = new LinkedHashSet<GoogleBaseAttributeId>();

    public List<GoogleBaseAttributeId> getAttributeIds() {
        return Collections.unmodifiableList(new ArrayList<GoogleBaseAttributeId>(this.attributeIds));
    }

    public Collection<GmAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public void addAttribute(String name, GoogleBaseAttributeType type) {
        GoogleBaseAttributeId attributeId = new GoogleBaseAttributeId(name, type);
        this.addAttribute(attributeId, null);
    }

    public void addAttribute(GoogleBaseAttributeId attributeId, GmAttribute.Importance importance) {
        if (this.attributeIds.contains(attributeId)) {
            throw new IllegalArgumentException("Attribute id already registered in the attributes group " + attributeId);
        }
        this.attributes.add(new GmAttribute(attributeId, importance));
        this.attributeIds.add(attributeId);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.attributes.isEmpty()) {
            return;
        }
        w.startElement(GoogleBaseNamespaces.GM, "attributes", null, null);
        w.startRepeatingElement();
        for (GmAttribute attribute : this.attributes) {
            ArrayList<XmlWriter.Attribute> attributes = new ArrayList<XmlWriter.Attribute>();
            GoogleBaseAttributeId id = attribute.getAttributeId();
            attributes.add(new XmlWriter.Attribute("name", id.getName()));
            if (id.getType() != null) {
                attributes.add(new XmlWriter.Attribute("type", id.getType().getName()));
            }
            if (attribute.getImportance() != null) {
                attributes.add(new XmlWriter.Attribute("importance", attribute.getImportance().getXmlValue()));
            }
            w.simpleElement(GoogleBaseNamespaces.GM, "attribute", attributes, null);
        }
        w.endRepeatingElement();
        w.endElement();
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException, IOException {
        this.attributes.clear();
        return new XmlParser.ElementHandler(){

            @Override
            public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
                if (namespace.equals("http://base.google.com/ns-metadata/1.0") && "attribute".equals(localName)) {
                    AttributeHelper helper = new AttributeHelper(attrs);
                    String nameAttr = helper.consume("name", true);
                    GoogleBaseAttributeType typeAttr = GoogleBaseAttributeType.getInstance(helper.consume("type", false));
                    GmAttribute.Importance importanceAttr = helper.consumeEnum("importance", false, GmAttribute.Importance.class);
                    GoogleBaseAttributeId attributeId = new GoogleBaseAttributeId(nameAttr, typeAttr);
                    GmAttributes.this.addAttribute(attributeId, importanceAttr);
                    helper.assertAllConsumed();
                    return new XmlParser.ElementHandler();
                }
                return super.getChildHandler(namespace, localName, attrs);
            }
        };
    }

    public static class GmAttribute {
        private final GoogleBaseAttributeId attributeId;
        private final Importance importance;

        public GmAttribute(GoogleBaseAttributeId attributeId, Importance importance) {
            if (attributeId == null) {
                throw new NullPointerException("AttributeId is null.");
            }
            this.attributeId = attributeId;
            this.importance = importance;
        }

        public GoogleBaseAttributeId getAttributeId() {
            return this.attributeId;
        }

        public Importance getImportance() {
            return this.importance;
        }

        public static enum Importance {
            REQUIRED,
            RECOMMENDED,
            OPTIONAL,
            DEPRECATED;

            private final String xmlValue = this.name().toLowerCase();

            String getXmlValue() {
                return this.xmlValue;
            }
        }
    }
}

