/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.audit;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.client.appsforyourdomain.audit.MailBoxDumpRequest;
import com.google.gdata.client.appsforyourdomain.audit.MailMonitor;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainErrorCode;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.data.appsforyourdomain.generic.GenericFeed;
import com.google.gdata.model.atom.Link;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditService
extends AppsPropertyService {
    public static final String BASE_URL = "https://apps-apis.google.com/a/feeds/compliance/audit/";
    private String domain = null;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd%20hh:mm");
    private static Logger LOGGER;

    public AuditService(String adminEmail, String adminPassword, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminEmail, adminPassword);
    }

    public AuditService(String domain, String applicationName) throws AuthenticationException {
        super(applicationName);
        this.domain = domain;
    }

    public GenericEntry createMailMonitor(String sourceUser, MailMonitor mailMonitor) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = mailMonitor.toGenericEntry();
        return this.insert(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/monitor/" + this.domain + "/" + sourceUser), entry);
    }

    public GenericFeed retrieveMonitors(String sourceUser) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/monitor/" + this.domain + "/" + sourceUser), GenericFeed.class);
    }

    public void deleteMonitor(String sourceUser, String destUser) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        this.delete(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/monitor/" + this.domain + "/" + sourceUser + "/" + destUser));
    }

    public GenericEntry uploadPublicKey(String base64encodedKey) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("publicKey", base64encodedKey);
        return this.insert(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/publickey/" + this.domain), entry);
    }

    public GenericEntry createMailboxDumpRequest(MailBoxDumpRequest mailBoxDumpRequest) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        String user = mailBoxDumpRequest.getUserEmailAddress().split("@")[0];
        URL url = new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/export/" + this.domain + "/" + user);
        return this.insert(url, mailBoxDumpRequest.toGenericEntry());
    }

    public List<GenericEntry> retrieveAllMailboxDumpRequests(Date fromDate) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        String url = "https://apps-apis.google.com/a/feeds/compliance/audit/mail/export/" + this.domain;
        if (fromDate != null) {
            url = url + "?fromDate=" + DATE_FORMAT.format(fromDate);
        }
        return this.getAllPages(new URL(url), GenericFeed.class);
    }

    public GenericFeed retrievePageOfMailboxDumpRequests(Date fromDate) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        String url = "https://apps-apis.google.com/a/feeds/compliance/audit/mail/export/" + this.domain;
        if (fromDate != null) {
            url = url + "?fromDate=" + DATE_FORMAT.format(fromDate);
        }
        return this.getFeed(new URL(url), GenericFeed.class);
    }

    public GenericFeed retrieveNextPageOfMailboxDumpRequests(Link next) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(next.getHref()), GenericFeed.class);
    }

    public GenericEntry retrieveMailboxDumpRequest(String user, String id) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getEntry(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/export/" + this.domain + "/" + user + "/" + id), GenericEntry.class);
    }

    public boolean deleteMailboxDumpRequest(String user, String id) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        try {
            this.delete(new URL("https://apps-apis.google.com/a/feeds/compliance/audit/mail/export/" + this.domain + "/" + user + "/" + id));
            return true;
        }
        catch (AppsForYourDomainException ex) {
            if (ex.getErrorCode() == AppsForYourDomainErrorCode.InvalidValue) {
                LOGGER.log(Level.INFO, "The request should either have status COMPLETED orMARKED_DELETE before being deleted");
            }
            return false;
        }
    }

    public GenericEntry createAccountInfoRequest(String user) throws AppsForYourDomainException, IOException, ServiceException {
        URL url = new URL("https://apps-apis.google.com/a/feeds/compliance/audit/account/" + this.domain + "/" + user);
        return this.insert(url, new GenericEntry());
    }

    public GenericEntry retrieveAccountInfoRequest(String user, String requestId) throws AppsForYourDomainException, IOException, ServiceException {
        URL url = new URL("https://apps-apis.google.com/a/feeds/compliance/audit/account/" + this.domain + "/" + user + "/" + requestId);
        return this.getEntry(url, GenericEntry.class);
    }

    public List<GenericEntry> retrieveAllAccountInfoRequests(Date fromDate) throws AppsForYourDomainException, IOException, ServiceException {
        String url = "https://apps-apis.google.com/a/feeds/compliance/audit/account/" + this.domain;
        if (fromDate != null) {
            url = url + "?fromDate=" + DATE_FORMAT.format(fromDate);
        }
        return this.getAllPages(new URL(url), GenericFeed.class);
    }

    public GenericFeed retrievePageOfAccountInfoRequests(Date fromDate) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        String url = "https://apps-apis.google.com/a/feeds/compliance/audit/account/" + this.domain;
        if (fromDate != null) {
            url = url + "?fromDate=" + DATE_FORMAT.format(fromDate);
        }
        return this.getFeed(new URL(url), GenericFeed.class);
    }

    public GenericFeed retrieveNextPageOfAccountInfoRequests(Link next) throws AppsForYourDomainException, MalformedURLException, IOException, ServiceException {
        return this.getFeed(new URL(next.getHref()), GenericFeed.class);
    }

    public void deleteAccountInfoRequest(String user, String requestId) throws AppsForYourDomainException, IOException, ServiceException {
        URL url = new URL("https://apps-apis.google.com/a/feeds/compliance/audit/account/" + this.domain + "/" + user + "/" + requestId);
        this.delete(url);
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT.setLenient(false);
        LOGGER = Logger.getLogger(AuditService.class.toString());
    }
}

