/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.audit;

import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MailBoxDumpRequest {
    private String packageContent;
    private boolean includeDeleted;
    private String searchQuery;
    private Date completedDate;
    private String adminEmailAddress;
    private int numberOfFiles;
    private String userEmailAddress;
    private String requestId;
    private Date endDate;
    private Date requestDate;
    private String status;
    private String[] fileUrls;
    private Date expiredDate;
    private Date beginDate;
    private static DateFormat DATE_FORMAT = null;

    public MailBoxDumpRequest(GenericEntry entry) {
        this.packageContent = entry.getProperty("packageContent");
        this.requestId = entry.getProperty("requestId");
        this.completedDate = this.checkDateAndParse(entry.getProperty("completedDate"));
        this.endDate = this.checkDateAndParse(entry.getProperty("endDate"));
        this.requestDate = this.checkDateAndParse(entry.getProperty("requestDate"));
        this.expiredDate = this.checkDateAndParse(entry.getProperty("expiredDate"));
        this.beginDate = this.checkDateAndParse(entry.getProperty("beginDate"));
        this.searchQuery = entry.getProperty("searchQuery");
        this.adminEmailAddress = entry.getProperty("adminEmailAddress");
        this.userEmailAddress = entry.getProperty("userEmailAddress");
        this.status = entry.getProperty("status");
        this.includeDeleted = entry.getProperty("includeDeleted") != null ? Boolean.parseBoolean(entry.getProperty("includeDeleted")) : this.includeDeleted;
        int n = this.numberOfFiles = entry.getProperty("numberOfFiles") != null ? Integer.parseInt(entry.getProperty("numberOfFiles")) : this.numberOfFiles;
        if (this.numberOfFiles > 0) {
            this.fileUrls = new String[this.numberOfFiles];
            for (int fileIndex = 0; fileIndex < this.numberOfFiles; ++fileIndex) {
                this.fileUrls[fileIndex] = entry.getProperty("fileUrl" + fileIndex);
            }
        }
    }

    public MailBoxDumpRequest() {
        this.includeDeleted = false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String[] getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(String[] fileUrls) {
        this.fileUrls = fileUrls;
    }

    public void setNumberOfFiles(int numberOfFiles) {
        this.numberOfFiles = numberOfFiles;
    }

    public int getNumberOfFiles() {
        return this.numberOfFiles;
    }

    public String getPackageContent() {
        return this.packageContent;
    }

    public void setPackageContent(String packageContent) {
        this.packageContent = packageContent;
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public String getAdminEmailAddress() {
        return this.adminEmailAddress;
    }

    public void setAdminEmailAddress(String adminEmailAddress) {
        this.adminEmailAddress = adminEmailAddress;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = requestDate;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public void setUserEmailAddress(String userEmailAddress) {
        this.userEmailAddress = userEmailAddress;
    }

    public Date getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(Date expiredDate) {
        this.expiredDate = expiredDate;
    }

    public GenericEntry toGenericEntry() {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("packageContent", this.packageContent);
        if (this.completedDate != null) {
            entry.addProperty("completedDate", DATE_FORMAT.format(this.completedDate));
        }
        if (this.endDate != null) {
            entry.addProperty("endDate", DATE_FORMAT.format(this.endDate));
        }
        if (this.beginDate != null) {
            entry.addProperty("beginDate", DATE_FORMAT.format(this.beginDate));
        }
        if (this.searchQuery != null) {
            entry.addProperty("searchQuery", this.searchQuery);
        }
        if (this.numberOfFiles != 0) {
            entry.addProperty("numberOfFiles", String.valueOf(this.numberOfFiles));
        }
        entry.addProperty("includeDeleted", String.valueOf(this.includeDeleted));
        entry.addProperty("adminEmailAddress", this.adminEmailAddress);
        return entry;
    }

    private Date checkDateAndParse(String date) {
        return date != null ? DATE_FORMAT.parse(date, new ParsePosition(0)) : null;
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT.setLenient(false);
    }
}

