/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.spreadsheet.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Cell
implements Extension {
    private int row = -1;
    private int col = -1;
    private String inputValue = null;
    private Number numericValue = null;
    private String value = null;

    public Cell() {
    }

    private Cell(int inRow, int inCol, String inInputValue, Number inNumericValue, String inValue) {
        this.row = inRow;
        this.col = inCol;
        this.inputValue = inInputValue;
        this.value = inValue;
        this.numericValue = inNumericValue;
    }

    public Cell(int inRow, int inCol, String inInputValue) {
        this(inRow, inCol, inInputValue, null, null);
    }

    public static Cell createFullCell(int inRow, int inCol, String inInputValue, Number inCalculatedValue, String inValue) {
        return new Cell(inRow, inCol, inInputValue, inCalculatedValue, inValue);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public double getDoubleValue() {
        if (this.numericValue == null) {
            return Double.NaN;
        }
        return this.numericValue.doubleValue();
    }

    public String getValue() {
        return this.value;
    }

    public Cell withNewInputValue(String newInputValue) {
        return new Cell(this.row, this.col, newInputValue, null, null);
    }

    public static ExtensionDescription getDefaultDescription(boolean repeats) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Cell.class);
        desc.setNamespace(Namespaces.gSpreadNs);
        desc.setLocalName("cell");
        desc.setRepeatable(repeats);
        return desc;
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.row > 0) {
            attrs.add(new XmlWriter.Attribute("row", String.valueOf(this.row)));
        }
        if (this.col > 0) {
            attrs.add(new XmlWriter.Attribute("col", String.valueOf(this.col)));
        }
        if (this.inputValue != null) {
            attrs.add(new XmlWriter.Attribute("inputValue", this.inputValue));
        }
        if (this.numericValue != null) {
            attrs.add(new XmlWriter.Attribute("numericValue", this.numericValue.toString()));
        }
        w.simpleElement(Namespaces.gSpreadNs, "cell", attrs, this.value);
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException, IOException {
        return new Handler();
    }

    private class Handler
    extends XmlParser.ElementHandler {
        @Override
        public void processAttribute(String namespace, String localName, String attributeData) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("row")) {
                    Cell.this.row = Integer.parseInt(attributeData);
                } else if (localName.equals("col")) {
                    Cell.this.col = Integer.parseInt(attributeData);
                } else if (localName.equals("inputValue")) {
                    Cell.this.inputValue = attributeData;
                } else if (localName.equals("numericValue")) {
                    try {
                        Cell.this.numericValue = Double.valueOf(attributeData);
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Invalid numericValue.");
                    }
                }
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            Cell.this.value = this.value;
            if (Cell.this.value != null && Cell.this.value.equals("")) {
                Cell.this.value = null;
            }
        }
    }
}

