/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.spreadsheet.Data;
import com.google.gdata.data.spreadsheet.Header;
import com.google.gdata.data.spreadsheet.Worksheet;

@Kind.Term(value="http://schemas.google.com/spreadsheets/2006#table")
public class TableEntry
extends BaseEntry<TableEntry> {
    public static final String KIND = "http://schemas.google.com/spreadsheets/2006#table";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/spreadsheets/2006#table");

    public TableEntry() {
        this.getCategories().add(CATEGORY);
    }

    public TableEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(TableEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(TableEntry.class, Data.getDefaultDescription(true, false));
        new Data().declareExtensions(extProfile);
        extProfile.declare(TableEntry.class, Header.getDefaultDescription(true, false));
        extProfile.declare(TableEntry.class, Worksheet.getDefaultDescription(true, false));
    }

    public Data getData() {
        return this.getExtension(Data.class);
    }

    public void setData(Data data) {
        if (data == null) {
            this.removeExtension(Data.class);
        } else {
            this.setExtension(data);
        }
    }

    public boolean hasData() {
        return this.hasExtension(Data.class);
    }

    public Header getHeader() {
        return this.getExtension(Header.class);
    }

    public void setHeader(Header header) {
        if (header == null) {
            this.removeExtension(Header.class);
        } else {
            this.setExtension(header);
        }
    }

    public boolean hasHeader() {
        return this.hasExtension(Header.class);
    }

    public Worksheet getWorksheet() {
        return this.getExtension(Worksheet.class);
    }

    public void setWorksheet(Worksheet worksheet) {
        if (worksheet == null) {
            this.removeExtension(Worksheet.class);
        } else {
            this.setExtension(worksheet);
        }
    }

    public boolean hasWorksheet() {
        return this.hasExtension(Worksheet.class);
    }

    public Link getRecordsFeedLink() {
        return this.getLink("http://schemas.google.com/spreadsheets/2006#recordsfeed", ILink.Type.ATOM);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{TableEntry " + super.toString() + "}";
    }
}

