/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;

public abstract class DateTimeValueConstruct
extends ValueConstruct {
    private DateTime dateTimeValue = null;

    public DateTimeValueConstruct(String nodeName) {
        super(Namespaces.WT_NAMESPACE, nodeName, null);
    }

    @Override
    public boolean equals(Object rhs) {
        if (!super.equals(rhs)) {
            return false;
        }
        DateTimeValueConstruct r = (DateTimeValueConstruct)rhs;
        if (this.dateTimeValue == null) {
            return r.dateTimeValue == null;
        }
        return this.dateTimeValue.equals(r.dateTimeValue);
    }

    @Override
    public int hashCode() {
        if (this.dateTimeValue == null) {
            return 0;
        }
        return this.dateTimeValue.hashCode();
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        try {
            DateTime parsedValue = DateTime.parseDateTime(value);
            this.setDateTime(parsedValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid date", e);
        }
    }

    public void setDateTime(DateTime value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.dateTimeValue = value;
        super.setValue(value.toString());
    }

    public DateTime getDateTime() {
        return this.dateTimeValue;
    }
}

