/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-mobile")
public class SitemapMobile
extends ExtensionPoint {
    public static final String SITEMAP_MOBILE = "sitemap-mobile";
    private static final String SITEMAP_MARKUP_LANG = "markup-language";

    public void addMarkupLanguage(String markupLanguage) {
        MarkupLanguageConstruct val = new MarkupLanguageConstruct();
        val.setValue(markupLanguage);
        this.addRepeatingExtension(val);
    }

    public Collection<String> getMarkupLanguages() {
        List<MarkupLanguageConstruct> langs = this.getRepeatingExtension(MarkupLanguageConstruct.class);
        ArrayList<String> ret = new ArrayList<String>(langs.size());
        for (MarkupLanguageConstruct l : langs) {
            ret.add(l.getValue());
        }
        return ret;
    }

    @Override
    public void generate(XmlWriter writer, ExtensionProfile profile) throws IOException {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(this.getClass());
        writer.startElement(desc.getNamespace(), desc.getLocalName(), null, null);
        this.generateExtensions(writer, profile);
        writer.endElement();
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="markup-language")
    static class MarkupLanguageConstruct
    extends ValueConstruct {
        public MarkupLanguageConstruct() {
            super(Namespaces.WT_NAMESPACE, SitemapMobile.SITEMAP_MARKUP_LANG, null);
        }
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile profile) {
            super(profile, SitemapMobile.class);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (localName == SitemapMobile.SITEMAP_MARKUP_LANG) {
                MarkupLanguageConstruct lang = new MarkupLanguageConstruct();
                SitemapMobile.this.addRepeatingExtension(lang);
                return lang.getHandler(null, namespace, localName, attrs);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

