/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.apt;

import com.google.gdata.data.Kind;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.Types;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DataAnnotationProcessorFactory
implements AnnotationProcessorFactory {
    private static List<String> supportedTypes = Collections.unmodifiableList(Arrays.asList("com.google.gdata.data.*"));

    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }

    public Collection<String> supportedAnnotationTypes() {
        return supportedTypes;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new DataAnnotationProcessor(env);
    }

    private static class DataAnnotationProcessor
    implements AnnotationProcessor {
        private AnnotationProcessorEnvironment env;

        private DataAnnotationProcessor(AnnotationProcessorEnvironment env) {
            this.env = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleKindTerms() {
            Messager msg = this.env.getMessager();
            Filer filer = this.env.getFiler();
            AnnotationTypeDeclaration kindDecl = (AnnotationTypeDeclaration)this.env.getTypeDeclaration(Kind.Term.class.getName());
            if (kindDecl == null) {
                msg.printError("Unable to find the Kind.Term annotation type");
                return;
            }
            Types typeUtils = this.env.getTypeUtils();
            TypeDeclaration intfDecl = this.env.getTypeDeclaration(Kind.Adaptor.class.getName());
            InterfaceType declaratorType = (InterfaceType)typeUtils.getDeclaredType(intfDecl, new TypeMirror[0]);
            HashMap<String, ArrayList<String>> adaptorMap = new HashMap<String, ArrayList<String>>();
            for (Declaration decl : this.env.getDeclarationsAnnotatedWith(kindDecl)) {
                if (!(decl instanceof ClassDeclaration)) {
                    msg.printError(decl.getPosition(), "@Kind.Term may only be used to annotate a class");
                    continue;
                }
                ClassDeclaration classDecl = (ClassDeclaration)decl;
                ClassType classType = (ClassType)typeUtils.getDeclaredType((TypeDeclaration)classDecl, new TypeMirror[0]);
                if (!typeUtils.isAssignable((TypeMirror)classType, (TypeMirror)declaratorType)) {
                    msg.printError(classDecl.getPosition(), "Class annotated by @Kind.Term must implement Kind.Adaptor");
                    continue;
                }
                Kind.Term kindTerm = (Kind.Term)classDecl.getAnnotation(Kind.Term.class);
                ArrayList<String> kindAdaptors = (ArrayList<String>)adaptorMap.get(kindTerm.value());
                if (kindAdaptors == null) {
                    kindAdaptors = new ArrayList<String>();
                    adaptorMap.put(kindTerm.value(), kindAdaptors);
                }
                kindAdaptors.add(classDecl.toString());
            }
            for (String term : adaptorMap.keySet()) {
                String kindService = Kind.getKindServiceName(term);
                File servicePath = new File(kindService);
                PrintWriter pw = null;
                try {
                    pw = filer.createTextFile(Filer.Location.CLASS_TREE, "", servicePath, null);
                    pw.println("# GData Kind Adaptors for " + term);
                    for (String adaptorClass : (List)adaptorMap.get(term)) {
                        pw.println(adaptorClass);
                    }
                }
                catch (IOException ioe) {
                    msg.printError("Unable to write kind metadata:" + servicePath);
                    ioe.printStackTrace();
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
                msg.printNotice("Wrote kind metadata for " + term + " to " + servicePath);
            }
        }

        public void process() {
            this.handleKindTerms();
        }
    }
}

