/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.books;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gbs", nsUri="http://schemas.google.com/books/2008", localName="review")
public class Review
extends AbstractExtension {
    static final String XML_NAME = "review";
    private static final String LANG = "xml:lang";
    private static final String TYPE = "type";
    private String lang = null;
    private String type = null;
    private String value = null;

    public Review() {
    }

    public Review(String lang, String type, String value) {
        this.setLang(lang);
        this.setType(type);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.throwExceptionIfImmutable();
        this.lang = lang;
    }

    public boolean hasLang() {
        return this.getLang() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Review.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(LANG, this.lang);
        generator.put(TYPE, this.type);
        generator.setContent(this.value);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.lang = helper.consume("lang", false);
        this.type = helper.consume(TYPE, false);
        this.value = helper.consume(null, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Review other = (Review)obj;
        return Review.eq(this.lang, other.lang) && Review.eq(this.type, other.type) && Review.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.lang != null) {
            result = 37 * result + this.lang.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Review lang=" + this.lang + " type=" + this.type + " value=" + this.value + "}";
    }
}

