/**
 * Mule Google Api Commons
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */


package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;

/**
 * Class that glues {@link ChangelogEntry} which was generated by the genesis
 * tool to its hand-written superclass ({@link DocumentListEntry}).
 *
 * @param <E> unused (necessary to meet the API that {@link ChangelogEntry}
 *    expects
 * 
 */
public class BaseDocumentListEntry<E> extends DocumentListEntry {

  /**
   * Constructs a new uninitialized entry, to be populated by the
   * GData parsers.
   */
  public BaseDocumentListEntry() {
    super();
  }

  /**
   * Constructs a new entry by doing a shallow copy from another {@link
   * BaseEntry} instance.
   */
  public BaseDocumentListEntry(BaseEntry<?> sourceEntry) {
    super(sourceEntry);
  }
}
