/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Link;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;

public abstract class MediaFeed<F extends BaseFeed, E extends BaseEntry>
extends BaseFeed<F, E> {
    protected MediaFeed(Class<? extends E> entryClass) {
        super(entryClass);
    }

    protected MediaFeed(Class<? extends E> entryClass, BaseFeed<?, ?> sourceFeed) {
        super(entryClass, sourceFeed);
    }

    @Override
    public void setService(Service v) {
        if (!(v instanceof MediaService)) {
            throw new IllegalArgumentException("Service does not support media");
        }
        super.setService(v);
    }

    @Override
    public E insert(MediaSource media) throws ServiceException, IOException {
        return (E)this.insert(media, this.entryClass);
    }

    protected <T extends E> T insert(MediaSource media, Class<T> mediaEntryClass) throws ServiceException, IOException {
        if (this.feedState.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link postLink = this.getEntryPostLink();
        if (postLink == null) {
            throw new UnsupportedOperationException("Media cannot be inserted");
        }
        URL postUrl = new URL(postLink.getHref());
        return (T)((BaseEntry)((MediaService)this.feedState.service).insert(postUrl, mediaEntryClass, media));
    }
}

