/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos.impl;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaDescription;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.media.mediarss.MediaTitle;
import com.google.gdata.data.photos.MediaData;
import java.util.Collections;
import java.util.List;

public class MediaDataImpl
implements MediaData {
    private ExtensionPoint extPoint;

    public MediaDataImpl(ExtensionPoint extensionPoint) {
        this.extPoint = extensionPoint;
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        Class<?> extClass = this.extPoint.getClass();
        extProfile.declare(extClass, MediaGroup.getDefaultDescription());
        extProfile.declareArbitraryXmlExtension(MediaGroup.class);
        if (BaseEntry.class.isAssignableFrom(extClass)) {
            extProfile.declare(BaseEntry.class, MediaGroup.getDefaultDescription());
        }
        extProfile.declare(MediaGroup.class, MediaContent.getDefaultDescription(true));
        extProfile.declareArbitraryXmlExtension(MediaContent.class);
        extProfile.declare(MediaGroup.class, ExtensionDescription.getDefaultDescription(MediaTitle.class));
        extProfile.declare(MediaGroup.class, ExtensionDescription.getDefaultDescription(MediaDescription.class));
        extProfile.declare(MediaGroup.class, MediaKeywords.getDefaultDescription());
        ExtensionDescription thumbDesc = MediaThumbnail.getDefaultDescription();
        thumbDesc.setRepeatable(true);
        extProfile.declare(MediaGroup.class, thumbDesc);
        extProfile.declareArbitraryXmlExtension(MediaThumbnail.class);
        extProfile.declare(MediaGroup.class, ExtensionDescription.getDefaultDescription(MediaCredit.class));
    }

    @Override
    public MediaGroup getMediaGroup() {
        return this.extPoint.getExtension(MediaGroup.class);
    }

    @Override
    public List<MediaContent> getMediaContents() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getContents();
    }

    @Override
    public List<MediaCategory> getMediaCategories() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCategories();
    }

    @Override
    public List<MediaCredit> getMediaCredits() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getCredits();
    }

    @Override
    public List<MediaThumbnail> getMediaThumbnails() {
        MediaGroup group = this.getMediaGroup();
        if (group == null) {
            return Collections.emptyList();
        }
        return group.getThumbnails();
    }

    @Override
    public MediaKeywords getMediaKeywords() {
        MediaGroup group = this.getMediaGroup();
        if (group != null) {
            return group.getKeywords();
        }
        return null;
    }

    @Override
    public void setKeywords(MediaKeywords keywords) {
        MediaGroup group = this.extPoint.getExtension(MediaGroup.class);
        if (group == null) {
            group = new MediaGroup();
            this.extPoint.addExtension(group);
        }
        group.setKeywords(keywords);
    }

    @Override
    public void addExtension(Extension extension) {
        this.extPoint.addExtension(extension);
    }

    @Override
    public void setExtension(Extension extension) {
        this.extPoint.setExtension(extension);
    }

    @Override
    public void addRepeatingExtension(Extension extension) {
        this.extPoint.addRepeatingExtension(extension);
    }

    @Override
    public void removeExtension(Class<? extends Extension> extensionClass) {
        this.extPoint.removeExtension(extensionClass);
    }

    @Override
    public void removeExtension(Extension extension) {
        this.extPoint.removeExtension(extension);
    }

    @Override
    public void removeRepeatingExtension(Extension extension) {
        this.extPoint.removeRepeatingExtension(extension);
    }
}

