/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.projecthosting;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.projecthosting.Description;
import com.google.gdata.data.projecthosting.IssuesLink;
import com.google.gdata.data.projecthosting.ProjectLabel;
import com.google.gdata.data.projecthosting.Repository;
import java.util.List;

public class ProjectSummaryEntry
extends BaseEntry<ProjectSummaryEntry> {
    public ProjectSummaryEntry() {
    }

    public ProjectSummaryEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(ProjectSummaryEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(ProjectSummaryEntry.class, Description.class);
        extProfile.declare(ProjectSummaryEntry.class, IssuesLink.getDefaultDescription(false, true));
        extProfile.declare(ProjectSummaryEntry.class, ProjectLabel.getDefaultDescription(false, true));
        extProfile.declare(ProjectSummaryEntry.class, Repository.getDefaultDescription(false, true));
        new Repository().declareExtensions(extProfile);
    }

    public Description getDescription() {
        return this.getExtension(Description.class);
    }

    public void setDescription(Description description) {
        if (description == null) {
            this.removeExtension(Description.class);
        } else {
            this.setExtension(description);
        }
    }

    public boolean hasDescription() {
        return this.hasExtension(Description.class);
    }

    public List<ProjectLabel> getProjectLabels() {
        return this.getRepeatingExtension(ProjectLabel.class);
    }

    public void addProjectLabel(ProjectLabel projectLabel) {
        this.getProjectLabels().add(projectLabel);
    }

    public boolean hasProjectLabels() {
        return this.hasRepeatingExtension(ProjectLabel.class);
    }

    public List<Repository> getRepositories() {
        return this.getRepeatingExtension(Repository.class);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    public boolean hasRepositories() {
        return this.hasRepeatingExtension(Repository.class);
    }

    public Link getRelatedLink() {
        return this.getLink("related", ILink.Type.ATOM);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{ProjectSummaryEntry " + super.toString() + "}";
    }
}

