/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.client.spreadsheet.SpreadsheetService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetFeed;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

@Kind.Term(value="http://schemas.google.com/spreadsheets/2006#spreadsheet")
public class SpreadsheetEntry
extends BaseEntry<SpreadsheetEntry> {
    public static final String KIND = "http://schemas.google.com/spreadsheets/2006#spreadsheet";
    public static final Category CATEGORY = new Category("http://schemas.google.com/spreadsheets/2006", "http://schemas.google.com/spreadsheets/2006#spreadsheet");

    public SpreadsheetEntry() {
        this.getCategories().add(CATEGORY);
    }

    public SpreadsheetEntry(BaseEntry sourceEntry) {
        super(sourceEntry);
        this.getCategories().add(CATEGORY);
    }

    public Link getSpreadsheetLink() {
        return super.getHtmlLink();
    }

    public URL getWorksheetFeedUrl() {
        try {
            return new URL(this.getWorksheetFeedUrlString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error in GData server", e);
        }
    }

    private String getWorksheetFeedUrlString() {
        Version spreadsheetVersion = this.state.service.getProtocolVersion();
        if (spreadsheetVersion.isCompatible(SpreadsheetService.Versions.V1)) {
            Link feedLink = this.getLink("http://schemas.google.com/spreadsheets/2006#worksheetsfeed", ILink.Type.ATOM);
            return feedLink.getHref();
        }
        return ((OutOfLineContent)this.getContent()).getUri();
    }

    public List<WorksheetEntry> getWorksheets() throws IOException, ServiceException {
        WorksheetFeed feed = this.state.service.getFeed(this.getWorksheetFeedUrl(), WorksheetFeed.class);
        return feed.getEntries();
    }

    public WorksheetEntry getDefaultWorksheet() throws IOException, ServiceException {
        String url = this.getWorksheetFeedUrlString() + "/default";
        return this.state.service.getEntry(new URL(url), WorksheetEntry.class);
    }

    public String getKey() {
        String result = this.state.id;
        int position = result.lastIndexOf("/");
        if (position > 0) {
            result = result.substring(position + 1);
        }
        return result;
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
    }
}

