/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.media;

import com.google.gdata.client.media.MediaService;
import com.google.gdata.client.uploader.ProgressListener;
import com.google.gdata.client.uploader.ResumableHttpFileUploader;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.media.MediaFileSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ResumableUploadException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ResumableGDataFileUploader
extends ResumableHttpFileUploader {
    public static final String RESUMABLE_EDIT_MEDIA_REL = "resumable-edit-media";
    private final MediaService service;

    private ResumableGDataFileUploader(URL uploadUrl, MediaFileSource file, MediaService service, long chunkSize, ExecutorService executor, ProgressListener progressListener, long progressIntervalMillis) throws IOException, ServiceException {
        super(uploadUrl, file.getMediaFile(), executor, progressListener, chunkSize, progressIntervalMillis);
        this.service = service;
    }

    public <E extends IEntry> E getResponse(Class<E> entryClass) throws IOException, ServiceException {
        InputStream response = super.getResponse().getInputStream();
        if (this.getUploadState() == ResumableHttpFileUploader.UploadState.CLIENT_ERROR) {
            throw new ResumableUploadException("client error");
        }
        if (response == null) {
            System.out.println("No response found");
            return null;
        }
        return (E)((IEntry)this.service.parseResumableUploadResponse(response, ContentType.ATOM, entryClass));
    }

    public static class Builder {
        private URL mediaUrl;
        private IEntry mediaEntry;
        private MediaService mediaService;
        private MediaFileSource mediaFile;
        private String mediaTitle;
        private long chunkSize = ResumableHttpFileUploader.DEFAULT_MAX_CHUNK_SIZE;
        private ExecutorService executor = Executors.newSingleThreadExecutor();
        private ProgressListener listener;
        private long progressInterval = 100L;
        RequestType requestType = RequestType.INSERT;

        public Builder(MediaService service, URL mediaUrl, MediaFileSource mediaFile, IEntry mediaEntry) {
            this.mediaService = service;
            this.mediaUrl = mediaUrl;
            this.mediaFile = mediaFile;
            this.mediaEntry = mediaEntry;
        }

        public Builder(MediaService service, MediaFileSource mediaFile, IEntry entryToUpdate) {
            this.mediaEntry = entryToUpdate;
            this.mediaFile = mediaFile;
            this.mediaService = service;
        }

        public Builder title(String mediaTitle) {
            this.mediaTitle = mediaTitle;
            return this;
        }

        public Builder chunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder trackProgress(ProgressListener listener, long progressInterval) {
            this.listener = listener;
            this.progressInterval = progressInterval;
            return this;
        }

        public Builder requestType(RequestType requestType) {
            this.requestType = requestType;
            return this;
        }

        public ResumableGDataFileUploader build() throws IOException, ServiceException {
            Preconditions.checkState(this.mediaUrl != null || this.mediaEntry != null);
            Preconditions.checkNotNull(this.mediaService);
            Preconditions.checkNotNull(this.mediaFile);
            URL uploadUrl = null;
            switch (this.requestType) {
                case INSERT: {
                    if (this.mediaEntry != null) {
                        uploadUrl = this.mediaService.createResumableUploadSession(this.mediaUrl, this.mediaEntry, this.mediaFile);
                        break;
                    }
                    uploadUrl = this.mediaService.createResumableUploadSession(this.mediaUrl, this.mediaTitle, this.mediaFile);
                    break;
                }
                case UPDATE: {
                    uploadUrl = this.mediaService.createResumableUpdateSession(new URL(this.mediaEntry.getResumableEditMediaLink().getHref()), this.mediaEntry, this.mediaFile, false);
                    break;
                }
                case UPDATE_MEDIA_ONLY: {
                    if (this.mediaEntry != null) {
                        this.mediaUrl = new URL(this.mediaEntry.getResumableEditMediaLink().getHref());
                    }
                    uploadUrl = this.mediaService.createResumableUpdateSession(this.mediaUrl, this.mediaEntry, this.mediaFile, true);
                }
            }
            ResumableGDataFileUploader uploader = new ResumableGDataFileUploader(uploadUrl, this.mediaFile, this.mediaService, this.chunkSize, this.executor, this.listener, this.progressInterval);
            uploader.addHeader("Content-Type", this.mediaFile.getContentType());
            return uploader;
        }
    }

    public static enum RequestType {
        INSERT,
        UPDATE,
        UPDATE_MEDIA_ONLY;

    }
}

