/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.analytics.AnalyticsLink;
import com.google.gdata.data.analytics.Goal;
import com.google.gdata.data.analytics.Property;
import com.google.gdata.data.analytics.Segment;
import java.util.ArrayList;
import java.util.List;

public class ManagementEntry
extends BaseEntry<ManagementEntry> {
    public ManagementEntry() {
    }

    public ManagementEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(ManagementEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(ManagementEntry.class, Goal.class);
        new Goal().declareExtensions(extProfile);
        extProfile.declare(ManagementEntry.class, AnalyticsLink.getDefaultDescription(false, true));
        extProfile.declare(ManagementEntry.class, Property.getDefaultDescription(false, true));
        extProfile.declare(ManagementEntry.class, Segment.class);
        new Segment().declareExtensions(extProfile);
    }

    public Goal getGoal() {
        return this.getExtension(Goal.class);
    }

    public void setGoal(Goal goal) {
        if (goal == null) {
            this.removeExtension(Goal.class);
        } else {
            this.setExtension(goal);
        }
    }

    public boolean hasGoal() {
        return this.hasExtension(Goal.class);
    }

    public List<Property> getProperties() {
        return this.getRepeatingExtension(Property.class);
    }

    public void addProperty(Property property) {
        this.getProperties().add(property);
    }

    public boolean hasProperties() {
        return this.hasRepeatingExtension(Property.class);
    }

    public Segment getSegment() {
        return this.getExtension(Segment.class);
    }

    public void setSegment(Segment segment) {
        if (segment == null) {
            this.removeExtension(Segment.class);
        } else {
            this.setExtension(segment);
        }
    }

    public boolean hasSegment() {
        return this.hasExtension(Segment.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{ManagementEntry " + super.toString() + "}";
    }

    public String getProperty(String name) {
        if (this.hasProperties()) {
            for (Property property : this.getProperties()) {
                if (!property.hasName() || !property.getName().equalsIgnoreCase(name)) continue;
                return property.getValue();
            }
        }
        return null;
    }

    public List<AnalyticsLink> getParentLinks() {
        ArrayList<AnalyticsLink> links = new ArrayList<AnalyticsLink>();
        for (Link link : this.getLinks()) {
            if (!link.getRel().equals("http://schemas.google.com/ga/2009#parent")) continue;
            links.add((AnalyticsLink)link);
        }
        return links;
    }

    public List<AnalyticsLink> getChildLinks() {
        ArrayList<AnalyticsLink> links = new ArrayList<AnalyticsLink>();
        for (Link link : this.getLinks()) {
            if (!link.getRel().equals("http://schemas.google.com/ga/2009#child")) continue;
            links.add((AnalyticsLink)link);
        }
        return links;
    }

    public AnalyticsLink getChildLink(String targetKind) {
        for (Link link : this.getLinks()) {
            AnalyticsLink analyticsLink;
            if (!link.getRel().equals("http://schemas.google.com/ga/2009#child") || !(analyticsLink = (AnalyticsLink)link).getTargetKind().equals(targetKind)) continue;
            return analyticsLink;
        }
        return null;
    }
}

