/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.media.MediaEntry;
import com.google.gdata.data.photos.AtomData;
import com.google.gdata.data.photos.GphotoData;
import com.google.gdata.data.photos.GphotoFeed;
import com.google.gdata.data.photos.impl.GphotoDataImpl;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.net.URL;

public class GphotoEntry<E extends GphotoEntry<E>>
extends MediaEntry<E>
implements GphotoData,
AtomData {
    private final GphotoData delegate = new GphotoDataImpl(this);

    public GphotoEntry() {
    }

    protected GphotoEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        this.delegate.declareExtensions(extProfile);
        super.declareExtensions(extProfile);
    }

    public Link getFeedLink() {
        Link feedLink = this.getLink("http://schemas.google.com/g/2005#feed", ILink.Type.ATOM);
        return feedLink;
    }

    public <F extends GphotoFeed<F>> F getFeed(Class<F> feedClass, String ... kinds) throws IOException, ServiceException {
        if (this.state.service == null) {
            throw new ServiceException("Entry is not associated with a GData service.");
        }
        Link feedLink = this.getFeedLink();
        if (feedLink == null) {
            throw new UnsupportedOperationException("Missing feed link.");
        }
        String feedHref = feedLink.getHref();
        if (kinds != null && kinds.length > 0) {
            StringBuilder kindBuilder = new StringBuilder();
            for (int i = 0; i < kinds.length; ++i) {
                if (i > 0) {
                    kindBuilder.append(',');
                }
                kindBuilder.append(kinds[i]);
            }
            feedHref = feedHref.indexOf(63) == -1 ? feedHref + "?kind=" + kindBuilder : feedHref + "&kind=" + kindBuilder;
        }
        URL feedUrl = new URL(feedHref);
        return (F)((GphotoFeed)this.state.service.getFeed(feedUrl, feedClass));
    }

    @Override
    public String getGphotoId() {
        return this.delegate.getGphotoId();
    }

    @Override
    public void setGphotoId(Long id) {
        this.delegate.setGphotoId(id);
    }

    @Override
    public void setGphotoId(String id) {
        this.delegate.setGphotoId(id);
    }

    @Override
    public TextConstruct getDescription() {
        return this.getSummary();
    }

    @Override
    public void setDescription(TextConstruct description) {
        this.setSummary(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        TextConstruct summary = this.getSummary();
        try {
            if (summary != null) {
                this.setSummary(new SummaryTextConstruct(summary));
            }
            super.generateRss(w, extProfile);
        }
        finally {
            if (summary != null) {
                this.setSummary(summary);
            }
        }
    }

    @Override
    public GphotoEntry<?> getAdaptedEntry() throws Kind.AdaptorException {
        return (GphotoEntry)super.getAdaptedEntry();
    }

    private static class SummaryTextConstruct
    extends TextConstruct {
        private final TextConstruct wrapped;

        public SummaryTextConstruct(TextConstruct wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void generateAtom(XmlWriter w, String elementName) throws IOException {
            this.wrapped.generateRss(w, "description", TextConstruct.RssFormat.FULL_HTML);
        }

        @Override
        public void generateRss(XmlWriter w, String elementName, TextConstruct.RssFormat rssFormat) throws IOException {
            this.wrapped.generateRss(w, elementName, rssFormat);
        }

        @Override
        public String getPlainText() {
            return this.wrapped.getPlainText();
        }

        @Override
        public int getType() {
            return this.wrapped.getType();
        }

        @Override
        public boolean isEmpty() {
            return this.wrapped.isEmpty();
        }
    }
}

