/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.xml.sax.Attributes;

@ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="sitemap-news")
public class SitemapNews
extends ExtensionPoint {
    public static final String SITEMAP_NEWS = "sitemap-news";
    private static final String SITEMAP_PUBLICATION_LABEL = "publication-label";

    public void addPublicationLabel(String label) {
        PublicationLabelConstruct val = new PublicationLabelConstruct();
        val.setValue(label);
        this.addRepeatingExtension(val);
    }

    public Collection<String> getPublicationLabels() {
        List<PublicationLabelConstruct> labels = this.getRepeatingExtension(PublicationLabelConstruct.class);
        ArrayList<String> ret = new ArrayList<String>(labels.size());
        for (PublicationLabelConstruct l : labels) {
            ret.add(l.getValue());
        }
        return ret;
    }

    @Override
    public void generate(XmlWriter writer, ExtensionProfile profile) throws IOException {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(this.getClass());
        writer.startElement(desc.getNamespace(), desc.getLocalName(), null, null);
        this.generateExtensions(writer, profile);
        writer.endElement();
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="publication-label")
    static class PublicationLabelConstruct
    extends ValueConstruct {
        public PublicationLabelConstruct() {
            super(Namespaces.WT_NAMESPACE, SitemapNews.SITEMAP_PUBLICATION_LABEL, null);
        }
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile profile) {
            super(profile, SitemapNews.class);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (localName == SitemapNews.SITEMAP_PUBLICATION_LABEL) {
                PublicationLabelConstruct label = new PublicationLabelConstruct();
                SitemapNews.this.addRepeatingExtension(label);
                return label.getHandler(null, namespace, localName, attrs);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

