/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.extensions.FeedLink;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.YouTubeNamespace;
import com.google.gdata.data.youtube.YtAboutMe;
import com.google.gdata.data.youtube.YtAge;
import com.google.gdata.data.youtube.YtBooks;
import com.google.gdata.data.youtube.YtCompany;
import com.google.gdata.data.youtube.YtDescription;
import com.google.gdata.data.youtube.YtFirstName;
import com.google.gdata.data.youtube.YtGender;
import com.google.gdata.data.youtube.YtHobbies;
import com.google.gdata.data.youtube.YtHometown;
import com.google.gdata.data.youtube.YtLastName;
import com.google.gdata.data.youtube.YtLocation;
import com.google.gdata.data.youtube.YtMovies;
import com.google.gdata.data.youtube.YtMusic;
import com.google.gdata.data.youtube.YtOccupation;
import com.google.gdata.data.youtube.YtRelationship;
import com.google.gdata.data.youtube.YtSchool;
import com.google.gdata.data.youtube.YtUserProfileStatistics;
import com.google.gdata.data.youtube.YtUsername;
import java.util.List;
import java.util.Set;

@Kind.Term(value="http://gdata.youtube.com/schemas/2007#userProfile")
public class UserProfileEntry
extends BaseEntry<UserProfileEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/channeltypes.cat"};

    public UserProfileEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#userProfile");
    }

    public UserProfileEntry(BaseEntry<?> base) {
        super(base);
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#userProfile");
    }

    public void setBooks(String books) {
        if (books == null) {
            this.removeExtension(YtBooks.class);
        } else {
            this.setExtension(new YtBooks(books));
        }
    }

    public String getBooks() {
        YtBooks books = this.getExtension(YtBooks.class);
        if (books != null) {
            return books.getContent();
        }
        return null;
    }

    public void setAge(Integer age) {
        if (age == null) {
            this.removeExtension(YtAge.class);
        } else {
            this.setExtension(new YtAge(age));
        }
    }

    public Integer getAge() {
        YtAge age = this.getExtension(YtAge.class);
        if (age == null) {
            return null;
        }
        return age.getAge();
    }

    public void setThumbnail(MediaThumbnail thumb) {
        if (thumb == null) {
            this.removeExtension(MediaThumbnail.class);
        } else {
            this.setExtension(thumb);
        }
    }

    public MediaThumbnail getThumbnail() {
        MediaThumbnail thumb = this.getExtension(MediaThumbnail.class);
        if (thumb == null) {
            return null;
        }
        return thumb;
    }

    public String getCompany() {
        YtCompany company = this.getExtension(YtCompany.class);
        if (company != null) {
            return company.getContent();
        }
        return null;
    }

    public void setCompany(String company) {
        if (company == null) {
            this.removeExtension(YtCompany.class);
        } else {
            this.setExtension(new YtCompany(company));
        }
    }

    public void setGender(YtGender.Value gender) {
        if (gender == null) {
            this.removeExtension(YtGender.class);
        } else {
            this.setExtension(new YtGender(gender));
        }
    }

    public YtGender.Value getGender() {
        YtGender gender = this.getExtension(YtGender.class);
        if (gender != null) {
            return gender.getGender();
        }
        return null;
    }

    public void setHobbies(String hobbies) {
        if (hobbies == null) {
            this.removeExtension(YtHobbies.class);
        } else {
            this.setExtension(new YtHobbies(hobbies));
        }
    }

    public String getHobbies() {
        YtHobbies hobbies = this.getExtension(YtHobbies.class);
        if (hobbies != null) {
            return hobbies.getContent();
        }
        return null;
    }

    public void setHometown(String hometown) {
        if (hometown == null) {
            this.removeExtension(YtHometown.class);
        } else {
            this.setExtension(new YtHometown(hometown));
        }
    }

    public String getHometown() {
        YtHometown hometown = this.getExtension(YtHometown.class);
        if (hometown != null) {
            return hometown.getContent();
        }
        return null;
    }

    public void setLocation(String location) {
        if (location == null) {
            this.removeExtension(YtLocation.class);
        } else {
            this.setExtension(new YtLocation(location));
        }
    }

    public String getLocation() {
        YtLocation location = this.getExtension(YtLocation.class);
        if (location != null) {
            return location.getContent();
        }
        return null;
    }

    public void setMovies(String movies) {
        if (movies == null) {
            this.removeExtension(YtMovies.class);
        } else {
            this.setExtension(new YtMovies(movies));
        }
    }

    public String getMovies() {
        YtMovies movies = this.getExtension(YtMovies.class);
        if (movies != null) {
            return movies.getContent();
        }
        return null;
    }

    public void setMusic(String music) {
        if (music == null) {
            this.removeExtension(YtMusic.class);
        } else {
            this.setExtension(new YtMusic(music));
        }
    }

    public String getMusic() {
        YtMusic music = this.getExtension(YtMusic.class);
        if (music != null) {
            return music.getContent();
        }
        return null;
    }

    public void setOccupation(String occupation) {
        if (occupation == null) {
            this.removeExtension(YtOccupation.class);
        } else {
            this.setExtension(new YtOccupation(occupation));
        }
    }

    public String getOccupation() {
        YtOccupation occupation = this.getExtension(YtOccupation.class);
        if (occupation != null) {
            return occupation.getContent();
        }
        return null;
    }

    public void setRelationship(YtRelationship.Status relationship) {
        if (relationship == null) {
            this.removeExtension(YtRelationship.class);
        } else {
            this.setExtension(new YtRelationship(relationship));
        }
    }

    public YtRelationship.Status getRelationship() {
        YtRelationship relationship = this.getExtension(YtRelationship.class);
        if (relationship != null) {
            return relationship.getStatus();
        }
        return null;
    }

    public void setSchool(String school) {
        if (school == null) {
            this.removeExtension(YtSchool.class);
        } else {
            this.setExtension(new YtSchool(school));
        }
    }

    public String getSchool() {
        YtSchool school = this.getExtension(YtSchool.class);
        if (school != null) {
            return school.getContent();
        }
        return null;
    }

    public String getUsername() {
        YtUsername username = this.getExtension(YtUsername.class);
        return username == null ? null : username.getContent();
    }

    public void setUsername(String name) {
        if (name == null) {
            this.removeExtension(YtUsername.class);
        } else {
            this.setExtension(new YtUsername(name));
        }
    }

    public String getFirstName() {
        YtFirstName firstname = this.getExtension(YtFirstName.class);
        return firstname == null ? null : firstname.getContent();
    }

    public void setFirstName(String firstname) {
        if (firstname == null) {
            this.removeExtension(YtFirstName.class);
        } else {
            this.setExtension(new YtFirstName(firstname));
        }
    }

    public String getLastName() {
        YtLastName lastname = this.getExtension(YtLastName.class);
        return lastname == null ? null : lastname.getContent();
    }

    public void setLastName(String lastname) {
        if (lastname == null) {
            this.removeExtension(YtLastName.class);
        } else {
            this.setExtension(new YtLastName(lastname));
        }
    }

    @Deprecated
    public String getDescription() {
        YtDescription description = this.getExtension(YtDescription.class);
        return description == null ? null : description.getContent();
    }

    @Deprecated
    public void setDescription(String description) {
        if (description == null) {
            this.removeExtension(YtDescription.class);
        } else {
            this.setExtension(new YtDescription(description));
        }
    }

    public String getAboutMe() {
        YtAboutMe aboutMe = this.getExtension(YtAboutMe.class);
        return aboutMe == null ? null : aboutMe.getContent();
    }

    public void setAboutMe(String aboutMe) {
        if (aboutMe == null) {
            this.removeExtension(YtAboutMe.class);
        } else {
            this.setExtension(new YtAboutMe(aboutMe));
        }
    }

    public YtUserProfileStatistics getStatistics() {
        return this.getExtension(YtUserProfileStatistics.class);
    }

    public void setStatistics(YtUserProfileStatistics ups) {
        if (ups == null) {
            this.removeExtension(YtUserProfileStatistics.class);
        } else {
            this.setExtension(ups);
        }
    }

    private Category getCategoryForScheme(Set<Category> categories, String scheme) {
        for (Category c : categories) {
            if (!c.getScheme().equals(scheme)) continue;
            return c;
        }
        return null;
    }

    public String getChannelType() {
        return this.getCategoryForScheme(this.getCategories(), "http://gdata.youtube.com/schemas/2007/channeltypes.cat").getTerm();
    }

    public void setChannelType(String channelTypeTerm) {
        if (channelTypeTerm == null) {
            this.getCategories().remove(this.getCategoryForScheme(this.getCategories(), "http://gdata.youtube.com/schemas/2007/channeltypes.cat"));
            return;
        }
        this.getCategories().add(new Category("http://gdata.youtube.com/schemas/2007/channeltypes.cat", channelTypeTerm));
    }

    public List<FeedLink> getFeedLinks() {
        return this.getRepeatingExtension(FeedLink.class);
    }

    public FeedLink<?> getFavoritesFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.favorites");
    }

    public FeedLink<?> getContactsFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.contacts");
    }

    public FeedLink<?> getInboxFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.inbox");
    }

    public FeedLink<?> getPlaylistsFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.playlists");
    }

    public FeedLink<?> getSubscriptionsFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.subscriptions");
    }

    public FeedLink<?> getUploadsFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.uploads");
    }

    public FeedLink<?> getNewSubscriptionVideosFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.newsubscriptionvideos");
    }

    public FeedLink<?> getFriendsActivityFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.friendsactivity");
    }

    public FeedLink<?> getRecentActivityFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.recentactivity");
    }

    public Link getVideoLogLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#user.vlog", ILink.Type.ATOM);
    }

    public Link getFeaturedVideoLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#featured-video", ILink.Type.ATOM);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declareAdditionalNamespace(YouTubeNamespace.NS);
        extProfile.declare(UserProfileEntry.class, YtAboutMe.class);
        extProfile.declare(UserProfileEntry.class, YtAge.class);
        extProfile.declare(UserProfileEntry.class, YtBooks.class);
        extProfile.declare(UserProfileEntry.class, YtCompany.class);
        extProfile.declare(UserProfileEntry.class, YtDescription.class);
        extProfile.declare(UserProfileEntry.class, YtGender.class);
        extProfile.declare(UserProfileEntry.class, YtHobbies.class);
        extProfile.declare(UserProfileEntry.class, YtHometown.class);
        extProfile.declare(UserProfileEntry.class, YtLocation.class);
        extProfile.declare(UserProfileEntry.class, YtMovies.class);
        extProfile.declare(UserProfileEntry.class, YtMusic.class);
        extProfile.declare(UserProfileEntry.class, YtOccupation.class);
        extProfile.declare(UserProfileEntry.class, YtRelationship.class);
        extProfile.declare(UserProfileEntry.class, YtSchool.class);
        extProfile.declare(UserProfileEntry.class, YtUsername.class);
        ExtensionDescription mediaThumbnailDescription = ExtensionDescription.getDefaultDescription(MediaThumbnail.class);
        mediaThumbnailDescription.setRepeatable(false);
        extProfile.declare(UserProfileEntry.class, mediaThumbnailDescription);
        extProfile.declare(UserProfileEntry.class, YtUserProfileStatistics.class);
        ExtensionDescription feedLinkDescription = FeedLink.getDefaultDescription();
        feedLinkDescription.setRepeatable(true);
        extProfile.declare(UserProfileEntry.class, feedLinkDescription);
        extProfile.declare(UserProfileEntry.class, YtFirstName.class);
        extProfile.declare(UserProfileEntry.class, YtLastName.class);
        extProfile.declareArbitraryXmlExtension(UserProfileEntry.class);
    }
}

