/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input;

import com.google.gdata.data.IAtom;
import com.google.gdata.data.ParseSource;
import com.google.gdata.model.Element;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.AtomDataParser;
import com.google.gdata.wireformats.input.ElementParser;
import com.google.gdata.wireformats.input.InputParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.IOException;

public class AtomDualParser
implements InputParser<IAtom> {
    private final InputParser<IAtom> dataParser = new AtomDataParser();
    private final InputParser<IAtom> elementParser = ElementParser.of(AltFormat.ATOM, IAtom.class);

    @Override
    public AltFormat getAltFormat() {
        return AltFormat.ATOM;
    }

    @Override
    public Class<IAtom> getResultType() {
        return IAtom.class;
    }

    @Override
    public <R extends IAtom> R parse(ParseSource parseSource, InputProperties inProps, Class<R> resultClass) throws IOException, ServiceException {
        Preconditions.checkNotNull(parseSource, "parseSource");
        Preconditions.checkNotNull(inProps, "inProps");
        Preconditions.checkNotNull("resultClass", resultClass);
        if (Element.class.isAssignableFrom(resultClass)) {
            return (R)((IAtom)this.elementParser.parse(parseSource, inProps, resultClass));
        }
        return (R)((IAtom)this.dataParser.parse(parseSource, inProps, resultClass));
    }
}

