/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.input.media;

import com.google.gdata.data.ParseSource;
import com.google.gdata.data.media.GDataContentHandler;
import com.google.gdata.data.media.MediaMultipart;
import com.google.gdata.util.InvalidEntryException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.input.AbstractParser;
import com.google.gdata.wireformats.input.InputProperties;
import java.io.InputStream;
import javax.mail.MessagingException;

public class MediaMultipartParser
extends AbstractParser<MediaMultipart> {
    public MediaMultipartParser() {
        super(AltFormat.MEDIA_MULTIPART, MediaMultipart.class);
    }

    protected MediaMultipart createMultipart(ParseSource parseSource, InputProperties inputProperties) throws MessagingException {
        return new MediaMultipart(inputProperties.getContentType().toString(), parseSource.getInputStream());
    }

    @Override
    public <R extends MediaMultipart> R parse(ParseSource parseSource, InputProperties inputProperties, Class<R> resultClass) throws ServiceException {
        Preconditions.checkArgument(MediaMultipart.class.isAssignableFrom(resultClass), "Result class must extend " + MediaMultipart.class.getName());
        InputStream inputStream = parseSource.getInputStream();
        Preconditions.checkNotNull(inputStream, "Parse source must be stream-based");
        InputProperties prevProperties = null;
        try {
            prevProperties = GDataContentHandler.setThreadInputProperties(inputProperties);
            MediaMultipart result = this.createMultipart(parseSource, inputProperties);
            MediaMultipart mediaMultipart = (MediaMultipart)((Object)resultClass.cast((Object)result));
            return (R)((Object)mediaMultipart);
        }
        catch (MessagingException me) {
            throw new InvalidEntryException(me.getMessage(), (Throwable)me);
        }
        finally {
            GDataContentHandler.setThreadInputProperties(prevProperties);
        }
    }
}

