/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="docs", nsUri="http://schemas.google.com/docs/2007", localName="importFormat")
public class ImportFormat
extends ExtensionPoint {
    static final String XML_NAME = "importFormat";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final AttributeHelper.EnumToAttributeValue<Target> TARGET_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.LowerCaseEnumToAttributeValue<Target>();
    private String source = null;
    private Target target = null;

    public ImportFormat() {
    }

    public ImportFormat(String source, Target target) {
        this.setSource(source);
        this.setTarget(target);
        this.setImmutable(true);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.throwExceptionIfImmutable();
        this.source = source;
    }

    public boolean hasSource() {
        return this.getSource() != null;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.throwExceptionIfImmutable();
        this.target = target;
    }

    public boolean hasTarget() {
        return this.getTarget() != null;
    }

    @Override
    protected void validate() {
        if (this.source == null) {
            ImportFormat.throwExceptionForMissingAttribute(SOURCE);
        }
        if (this.target == null) {
            ImportFormat.throwExceptionForMissingAttribute(TARGET);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(ImportFormat.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(SOURCE, this.source);
        generator.put(TARGET, this.target, TARGET_ENUM_TO_ATTRIBUTE_VALUE);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.source = helper.consume(SOURCE, true);
        this.target = helper.consumeEnum(TARGET, true, Target.class, null, TARGET_ENUM_TO_ATTRIBUTE_VALUE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ImportFormat other = (ImportFormat)obj;
        return ImportFormat.eq(this.source, other.source) && ImportFormat.eq((Object)this.target, (Object)other.target);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.source != null) {
            result = 37 * result + this.source.hashCode();
        }
        if (this.target != null) {
            result = 37 * result + this.target.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{ImportFormat source=" + this.source + " target=" + (Object)((Object)this.target) + "}";
    }

    public static enum Target {
        DOCUMENT,
        DRAWING,
        PRESENTATION,
        SPREADSHEET;

    }
}

