/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="gender")
public class YtGender
extends AbstractExtension {
    private Value gender;

    public YtGender() {
    }

    public YtGender(Value gender) {
        this.gender = gender;
    }

    public Value getGender() {
        return this.gender;
    }

    public void setGender(Value gender) {
        this.gender = gender;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.gender != null) {
            generator.setContent(this.gender.getId());
        }
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        this.gender = Value.fromId(helper.consumeContent(true));
        if (this.gender == null) {
            throw new ParseException("Unknown gender. It should be m or f.");
        }
    }

    public static enum Value {
        MALE("m"),
        FEMALE("f");

        private String id;

        private Value(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Value fromId(String id) {
            for (Value gender : Value.values()) {
                if (!gender.getId().equals(id)) continue;
                return gender;
            }
            return null;
        }
    }
}

