/**
 * Mule Google Api Commons
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */


package com.google.gdata.client.appsforyourdomain.audit;

import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * A simple POJO describing an Email Monitor.
 * 
 * 
 */
public class MailMonitor {

  private String requestId;
  private String destUserName;
  private Date beginDate;
  private Date endDate;
  private String incomingEmailMonitorLevel;
  private String outgoingEmailMonitorLevel;
  private String draftMonitorLevel;
  private String chatMonitorLevel;
  private static DateFormat DATE_FORMAT = null;

  static {
    DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm");
    DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    DATE_FORMAT.setLenient(false);
  }

  /**
   * Default constructor.
   */
  public MailMonitor() {
  }

  /**
   * Parameterized constructor that creates a MailMonitor instance from a 
   * {@link GenericEntry}
   * 
   * @param entry GenericEntry instance describing an Audit Monitor Entry.
   */
  public MailMonitor(GenericEntry entry) {
    requestId = entry.getProperty("requestId");
    destUserName = entry.getProperty("destUserName");
    beginDate = DATE_FORMAT.parse(entry.getProperty("beginDate"), new ParsePosition(0));
    endDate = DATE_FORMAT.parse(entry.getProperty("endDate"), new ParsePosition(0));
    incomingEmailMonitorLevel = entry.getProperty("incomingEmailMonitorLevel");
    outgoingEmailMonitorLevel = entry.getProperty("outgoingEmailMonitorLevel");
    draftMonitorLevel = entry.getProperty("draftMonitorLevel");
    chatMonitorLevel = entry.getProperty("chatMonitorLevel");
  }

  public String getRequestId() {
    return requestId;
  }

  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  public String getDestUserName() {
    return destUserName;
  }

  public void setDestUserName(String destUserName) {
    this.destUserName = destUserName;
  }

  public Date getBeginDate() {
    return beginDate;
  }

  public void setBeginDate(Date beginDate) {
    this.beginDate = beginDate;
  }

  public Date getEndDate() {
    return endDate;
  }

  public void setEndDate(Date endDate) {
    this.endDate = endDate;
  }

  public String getIncomingEmailMonitorLevel() {
    return incomingEmailMonitorLevel;
  }

  public void setIncomingEmailMonitorLevel(String incomingEmailMonitorLevel) {
    this.incomingEmailMonitorLevel = incomingEmailMonitorLevel;
  }

  public String getOutgoingEmailMonitorLevel() {
    return outgoingEmailMonitorLevel;
  }

  public void setOutgoingEmailMonitorLevel(String outgoingEmailMonitorLevel) {
    this.outgoingEmailMonitorLevel = outgoingEmailMonitorLevel;
  }

  public String getDraftMonitorLevel() {
    return draftMonitorLevel;
  }

  public void setDraftMonitorLevel(String draftMonitorLevel) {
    this.draftMonitorLevel = draftMonitorLevel;
  }

  public String getChatMonitorLevel() {
    return chatMonitorLevel;
  }

  public void setChatMonitorLevel(String chatMonitorLevel) {
    this.chatMonitorLevel = chatMonitorLevel;
  }

  /**
   * Creates a GenericEntry from the MailMonitor fields.
   * 
   * @return a GenericEntry with field values as properties.
   */
  public GenericEntry toGenericEntry() {
    GenericEntry entry = new GenericEntry();
    entry.addProperty("destUserName", destUserName);
    entry.addProperty("beginDate", DATE_FORMAT.format(beginDate));
    entry.addProperty("endDate", DATE_FORMAT.format(endDate));
    entry.addProperty("incomingEmailMonitorLevel", incomingEmailMonitorLevel);
    entry.addProperty("outgoingEmailMonitorLevel", outgoingEmailMonitorLevel);
    entry.addProperty("draftMonitorLevel", draftMonitorLevel);
    entry.addProperty("chatMonitorLevel", chatMonitorLevel);
    return entry;
  }
}
