/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="ga", nsUri="http://schemas.google.com/ga/2009", localName="customVariable")
public class CustomVariable
extends ExtensionPoint {
    static final String XML_NAME = "customVariable";
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private static final String SCOPE = "scope";
    private Integer index = null;
    private String name = null;
    private String scope = null;

    public CustomVariable() {
    }

    public CustomVariable(Integer index, String name, String scope) {
        this.setIndex(index);
        this.setName(name);
        this.setScope(scope);
        this.setImmutable(true);
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.throwExceptionIfImmutable();
        this.index = index;
    }

    public boolean hasIndex() {
        return this.getIndex() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.throwExceptionIfImmutable();
        this.scope = scope;
    }

    public boolean hasScope() {
        return this.getScope() != null;
    }

    @Override
    protected void validate() {
        if (this.index == null) {
            CustomVariable.throwExceptionForMissingAttribute(INDEX);
        }
        if (this.name == null) {
            CustomVariable.throwExceptionForMissingAttribute(NAME);
        }
        if (this.scope == null) {
            CustomVariable.throwExceptionForMissingAttribute(SCOPE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(CustomVariable.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(INDEX, this.index);
        generator.put(NAME, this.name);
        generator.put(SCOPE, this.scope);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.index = helper.consumeInteger(INDEX, true);
        this.name = helper.consume(NAME, true);
        this.scope = helper.consume(SCOPE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CustomVariable other = (CustomVariable)obj;
        return CustomVariable.eq(this.index, other.index) && CustomVariable.eq(this.name, other.name) && CustomVariable.eq(this.scope, other.scope);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.index != null) {
            result = 37 * result + this.index.hashCode();
        }
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.scope != null) {
            result = 37 * result + this.scope.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{CustomVariable index=" + this.index + " name=" + this.name + " scope=" + this.scope + "}";
    }

    public static final class Scope {
        public static final String HIT = "hit";
        public static final String VISIT = "visit";
        public static final String VISITOR = "visitor";
    }
}

