/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="dxp", nsUri="http://schemas.google.com/analytics/2009", localName="metric")
public class Metric
extends ExtensionPoint {
    static final String XML_NAME = "metric";
    private static final String CONFIDENCEINTERVAL = "confidenceInterval";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private Double confidenceInterval = null;
    private String name = null;
    private String type = null;
    private String value = null;

    public Metric() {
    }

    public Metric(Double confidenceInterval, String name, String type, String value) {
        this.setConfidenceInterval(confidenceInterval);
        this.setName(name);
        this.setType(type);
        this.setValue(value);
        this.setImmutable(true);
    }

    public Double getConfidenceInterval() {
        return this.confidenceInterval;
    }

    public void setConfidenceInterval(Double confidenceInterval) {
        this.throwExceptionIfImmutable();
        this.confidenceInterval = confidenceInterval;
    }

    public boolean hasConfidenceInterval() {
        return this.getConfidenceInterval() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
        if (this.name == null) {
            Metric.throwExceptionForMissingAttribute(NAME);
        }
        if (this.value == null) {
            Metric.throwExceptionForMissingAttribute(VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Metric.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(CONFIDENCEINTERVAL, this.confidenceInterval);
        generator.put(NAME, this.name);
        generator.put(TYPE, this.type);
        generator.put(VALUE, this.value);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.confidenceInterval = helper.consumeDouble(CONFIDENCEINTERVAL, false);
        this.name = helper.consume(NAME, true);
        this.type = helper.consume(TYPE, false);
        this.value = helper.consume(VALUE, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Metric other = (Metric)obj;
        return Metric.eq(this.confidenceInterval, other.confidenceInterval) && Metric.eq(this.name, other.name) && Metric.eq(this.type, other.type) && Metric.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.confidenceInterval != null) {
            result = 37 * result + this.confidenceInterval.hashCode();
        }
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Metric confidenceInterval=" + this.confidenceInterval + " name=" + this.name + " type=" + this.type + " value=" + this.value + "}";
    }

    public Number numericValue() {
        String type = this.getType();
        if ("integer".equals(type)) {
            return Long.parseLong(this.getValue());
        }
        return Double.parseDouble(this.getValue());
    }

    public long longValue() {
        return this.numericValue().longValue();
    }

    public double doubleValue() {
        return this.numericValue().doubleValue();
    }

    public static final class Type {
        public static final String CURRENCY = "currency";
        public static final String FLOAT = "float";
        public static final String INTEGER = "integer";
        public static final String PERCENT = "percent";
        public static final String TIME = "time";
        public static final String US_CURRENCY = "us_currency";
    }
}

