/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.appsforyourdomain;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum AppsForYourDomainErrorCode {
    UnknownError(1000),
    ServerBusy(1001),
    UserDeletedRecently(1100),
    UserSuspended(1101),
    DomainUserLimitExceeded(1200),
    DomainAliasLimitExceeded(1201),
    DomainSuspended(1202),
    DomainFeatureUnavailable(1203),
    EntityExists(1300),
    EntityDoesNotExist(1301),
    EntityNameIsReserved(1302),
    EntityNameNotValid(1303),
    EntityCannotBeModified(1304),
    EntityCannotContainCycle(1305),
    EntityHasMembersCannotDelete(1306),
    EntityQuotaLimitReached(1307),
    InvalidGivenName(1400),
    InvalidFamilyName(1401),
    InvalidPassword(1402),
    InvalidUsername(1403),
    InvalidHashFunctionName(1404),
    InvalidHashDigestLength(1405),
    InvalidEmailAddress(1406),
    InvalidQueryParameterValue(1407),
    InvalidSsoSigningKey(1408),
    InvalidEncryptionPublicKey(1409),
    FeatureUnavailableForUser(1410),
    EncryptionPublicKeyInvalidFormat(1411),
    EncryptionPublicKeyInvalidType(1412),
    EncryptionPublicKeyHasManyUserIds(1413),
    TooManyRecipientsOnEmailList(1500),
    TooManyNicknamesForUser(1501),
    DuplicateDestinations(1601),
    TooManyDestinations(1602),
    InvalidRouteAddress(1603),
    GroupCannotContainCycle(1700),
    InvalidGroupPermissions(1701),
    InvalidDomainEdition(1800),
    InvalidValue(1801),
    DeletePartialFailure(1802);

    private int errorCode;
    private static Map<Integer, AppsForYourDomainErrorCode> errorMap;

    private static Map<Integer, AppsForYourDomainErrorCode> makeErrorMap() {
        HashMap<Integer, AppsForYourDomainErrorCode> m = new HashMap<Integer, AppsForYourDomainErrorCode>();
        for (AppsForYourDomainErrorCode c : AppsForYourDomainErrorCode.values()) {
            m.put(c.errorCode, c);
        }
        return Collections.unmodifiableMap(m);
    }

    private AppsForYourDomainErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        return this.name() + "(" + this.errorCode + ")";
    }

    public int getErrorCodeAsInt() {
        return this.errorCode;
    }

    public static AppsForYourDomainErrorCode getEnumFromInt(Integer errorCode) {
        return errorMap.get(errorCode);
    }

    static {
        errorMap = AppsForYourDomainErrorCode.makeErrorMap();
    }
}

