/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.data.docs.ArchiveComplete;
import com.google.gdata.data.docs.ArchiveConversion;
import com.google.gdata.data.docs.ArchiveFailure;
import com.google.gdata.data.docs.ArchiveNotify;
import com.google.gdata.data.docs.ArchiveNotifyStatus;
import com.google.gdata.data.docs.ArchiveResourceId;
import com.google.gdata.data.docs.ArchiveStatus;
import com.google.gdata.data.docs.ArchiveTotal;
import com.google.gdata.data.docs.ArchiveTotalComplete;
import com.google.gdata.data.docs.ArchiveTotalFailure;
import com.google.gdata.data.extensions.QuotaBytesUsed;
import java.util.List;

@Kind.Term(value="http://schemas.google.com/docs/2007#archive")
public class ArchiveEntry
extends BaseEntry<ArchiveEntry> {
    public static final String KIND = "http://schemas.google.com/docs/2007#archive";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/docs/2007#archive", "archive");

    public ArchiveEntry() {
        this.getCategories().add(CATEGORY);
    }

    public ArchiveEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(ArchiveEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(ArchiveEntry.class, ArchiveComplete.class);
        extProfile.declare(ArchiveEntry.class, ArchiveConversion.getDefaultDescription(true, true));
        extProfile.declare(ArchiveEntry.class, ArchiveFailure.getDefaultDescription(false, true));
        extProfile.declare(ArchiveEntry.class, ArchiveNotify.class);
        extProfile.declare(ArchiveEntry.class, ArchiveNotifyStatus.class);
        extProfile.declare(ArchiveEntry.class, ArchiveResourceId.getDefaultDescription(false, true));
        extProfile.declare(ArchiveEntry.class, ArchiveStatus.class);
        extProfile.declare(ArchiveEntry.class, ArchiveTotal.class);
        extProfile.declare(ArchiveEntry.class, ArchiveTotalComplete.class);
        extProfile.declare(ArchiveEntry.class, ArchiveTotalFailure.class);
        extProfile.declare(ArchiveEntry.class, QuotaBytesUsed.class);
    }

    public ArchiveComplete getArchiveComplete() {
        return this.getExtension(ArchiveComplete.class);
    }

    public void setArchiveComplete(ArchiveComplete archiveComplete) {
        if (archiveComplete == null) {
            this.removeExtension(ArchiveComplete.class);
        } else {
            this.setExtension(archiveComplete);
        }
    }

    public boolean hasArchiveComplete() {
        return this.hasExtension(ArchiveComplete.class);
    }

    public List<ArchiveConversion> getArchiveConversions() {
        return this.getRepeatingExtension(ArchiveConversion.class);
    }

    public void addArchiveConversion(ArchiveConversion archiveConversion) {
        this.getArchiveConversions().add(archiveConversion);
    }

    public boolean hasArchiveConversions() {
        return this.hasRepeatingExtension(ArchiveConversion.class);
    }

    public List<ArchiveFailure> getArchiveFailures() {
        return this.getRepeatingExtension(ArchiveFailure.class);
    }

    public void addArchiveFailure(ArchiveFailure archiveFailure) {
        this.getArchiveFailures().add(archiveFailure);
    }

    public boolean hasArchiveFailures() {
        return this.hasRepeatingExtension(ArchiveFailure.class);
    }

    public ArchiveNotify getArchiveNotify() {
        return this.getExtension(ArchiveNotify.class);
    }

    public void setArchiveNotify(ArchiveNotify archiveNotify) {
        if (archiveNotify == null) {
            this.removeExtension(ArchiveNotify.class);
        } else {
            this.setExtension(archiveNotify);
        }
    }

    public boolean hasArchiveNotify() {
        return this.hasExtension(ArchiveNotify.class);
    }

    public ArchiveNotifyStatus getArchiveNotifyStatus() {
        return this.getExtension(ArchiveNotifyStatus.class);
    }

    public void setArchiveNotifyStatus(ArchiveNotifyStatus archiveNotifyStatus) {
        if (archiveNotifyStatus == null) {
            this.removeExtension(ArchiveNotifyStatus.class);
        } else {
            this.setExtension(archiveNotifyStatus);
        }
    }

    public boolean hasArchiveNotifyStatus() {
        return this.hasExtension(ArchiveNotifyStatus.class);
    }

    public List<ArchiveResourceId> getArchiveResourceIds() {
        return this.getRepeatingExtension(ArchiveResourceId.class);
    }

    public void addArchiveResourceId(ArchiveResourceId archiveResourceId) {
        this.getArchiveResourceIds().add(archiveResourceId);
    }

    public boolean hasArchiveResourceIds() {
        return this.hasRepeatingExtension(ArchiveResourceId.class);
    }

    public ArchiveStatus getArchiveStatus() {
        return this.getExtension(ArchiveStatus.class);
    }

    public void setArchiveStatus(ArchiveStatus archiveStatus) {
        if (archiveStatus == null) {
            this.removeExtension(ArchiveStatus.class);
        } else {
            this.setExtension(archiveStatus);
        }
    }

    public boolean hasArchiveStatus() {
        return this.hasExtension(ArchiveStatus.class);
    }

    public ArchiveTotal getArchiveTotal() {
        return this.getExtension(ArchiveTotal.class);
    }

    public void setArchiveTotal(ArchiveTotal archiveTotal) {
        if (archiveTotal == null) {
            this.removeExtension(ArchiveTotal.class);
        } else {
            this.setExtension(archiveTotal);
        }
    }

    public boolean hasArchiveTotal() {
        return this.hasExtension(ArchiveTotal.class);
    }

    public ArchiveTotalComplete getArchiveTotalComplete() {
        return this.getExtension(ArchiveTotalComplete.class);
    }

    public void setArchiveTotalComplete(ArchiveTotalComplete archiveTotalComplete) {
        if (archiveTotalComplete == null) {
            this.removeExtension(ArchiveTotalComplete.class);
        } else {
            this.setExtension(archiveTotalComplete);
        }
    }

    public boolean hasArchiveTotalComplete() {
        return this.hasExtension(ArchiveTotalComplete.class);
    }

    public ArchiveTotalFailure getArchiveTotalFailure() {
        return this.getExtension(ArchiveTotalFailure.class);
    }

    public void setArchiveTotalFailure(ArchiveTotalFailure archiveTotalFailure) {
        if (archiveTotalFailure == null) {
            this.removeExtension(ArchiveTotalFailure.class);
        } else {
            this.setExtension(archiveTotalFailure);
        }
    }

    public boolean hasArchiveTotalFailure() {
        return this.hasExtension(ArchiveTotalFailure.class);
    }

    public QuotaBytesUsed getQuotaBytesUsed() {
        return this.getExtension(QuotaBytesUsed.class);
    }

    public void setQuotaBytesUsed(QuotaBytesUsed quotaBytesUsed) {
        if (quotaBytesUsed == null) {
            this.removeExtension(QuotaBytesUsed.class);
        } else {
            this.setExtension(quotaBytesUsed);
        }
    }

    public boolean hasQuotaBytesUsed() {
        return this.hasExtension(QuotaBytesUsed.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{ArchiveEntry " + super.toString() + "}";
    }
}

