/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.client.media.MediaService;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Content;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.MediaContent;
import com.google.gdata.data.media.IMediaEntry;
import com.google.gdata.data.media.MediaSource;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.Attributes;

public abstract class MediaEntry<E extends BaseEntry<E>>
extends BaseEntry<E>
implements IMediaEntry {
    protected MediaEntry() {
    }

    protected MediaEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void setService(Service v) {
        if (!(v instanceof MediaService)) {
            throw new IllegalArgumentException("Service does not support media");
        }
        super.setService(v);
    }

    @Override
    public void setMediaSource(MediaSource mediaSource) {
        MediaContent content;
        if (this.state.content == null) {
            content = new MediaContent();
            this.state.content = content;
        } else if (this.state.content instanceof MediaContent) {
            content = (MediaContent)this.state.content;
        } else {
            throw new IllegalArgumentException("Cannot set media source on entry with existing non-MediaContent: " + this.state.content);
        }
        content.setMediaSource(mediaSource);
        content.setMimeType(new ContentType(mediaSource.getContentType()));
    }

    @Override
    public MediaSource getMediaSource() {
        MediaContent mediaContent;
        if (this.state.content instanceof MediaContent && (mediaContent = (MediaContent)this.state.content) != null) {
            return mediaContent.getMediaSource();
        }
        return null;
    }

    @Override
    public Link getMediaEditLink() {
        Link mediaLink = this.getLink("edit-media", null);
        if (mediaLink == null) {
            mediaLink = this.getLink("media-edit", null);
        }
        return mediaLink;
    }

    public E updateMedia(boolean updateEntry) throws IOException, ServiceException {
        MediaSource media = this.getMediaSource();
        if (media == null) {
            throw new NullPointerException("Must supply media source");
        }
        if (this.state.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link mediaLink = this.getMediaEditLink();
        if (mediaLink == null) {
            throw new UnsupportedOperationException("Media cannot be updated");
        }
        URL mediaUrl = new URL(mediaLink.getHref());
        MediaService service = (MediaService)this.state.service;
        if (!updateEntry) {
            return (E)((BaseEntry)service.updateMedia(mediaUrl, this.getClass(), media));
        }
        return (E)service.updateMedia(mediaUrl, this);
    }

    @Override
    protected Content.ChildHandlerInfo getContentHandlerInfo(ExtensionProfile extProfile, Attributes attrs) throws ParseException, IOException {
        return MediaContent.getChildHandler(extProfile, attrs);
    }
}

