/**
 * Mule Google Api Commons
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */


package com.google.gdata.data;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.io.IOException;

/**
 * A generic source of xml events that can be parsed by an instance of
 * {@link DefaultHandler}.
 * 
 * 
 */
public interface XmlEventSource {

  /**
   * Parse this event source with the given xml handler.
   * 
   * @param handler an xml handler that can handle the xml event source.
   * @throws SAXException if parsing fails.
   */
  public void parse(DefaultHandler handler) throws SAXException, IOException;
}
