/**
 * Mule Google Api Commons
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */


package com.google.gdata.data.codesearch;

import com.google.gdata.util.common.xml.XmlNamespace;

/**
 * GData namespace definitions related to Google Code Search.
 *
 * 
 */
public class Namespaces {

  private Namespaces() {}

  /** Google Code Search (GCS) namespace */
  public static final String gCS = "http://schemas.google.com/codesearch/2006";

  /** Google Code Search (GCS) namespace prefix */
  public static final String gCSNamespacePrefix = gCS + "#";

  /** Google Code Search (GCS) namespace alias */
  public static final String gCSPrefix = "gcs";

  /** XML writer namespace for Google Code Search (GCS) */
  public static final XmlNamespace gCSNs = new XmlNamespace(gCSPrefix, gCS);

}
