/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.appsforyourdomain.adminsettings;

import com.google.gdata.client.appsforyourdomain.AppsPropertyService;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.generic.GenericEntry;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.net.URL;

public class SingleSignOnService
extends AppsPropertyService {
    protected String ssoSettingsUrl;
    protected String ssoSigningKeyUrl;
    protected String domainUrlBase;

    public SingleSignOnService(String domain, String applicationName) {
        super(applicationName);
        this.domainUrlBase = "https://apps-apis.google.com/a/feeds/domain/2.0/" + domain + "/";
        this.ssoSettingsUrl = this.domainUrlBase + "sso/general";
        this.ssoSigningKeyUrl = this.domainUrlBase + "sso/signingkey";
    }

    public SingleSignOnService(String adminEmail, String password, String domain, String applicationName) throws AuthenticationException {
        this(domain, applicationName);
        this.setUserCredentials(adminEmail, password);
    }

    public GenericEntry updateSSOSettings(GenericEntry entry) throws AppsForYourDomainException, IOException, ServiceException {
        return this.update(new URL(this.ssoSettingsUrl), entry);
    }

    public GenericEntry updateSsoSigningKey(String base64EncodedKey) throws IOException, AppsForYourDomainException, ServiceException {
        GenericEntry entry = new GenericEntry();
        entry.addProperty("signingKey", base64EncodedKey);
        return this.update(new URL(this.ssoSigningKeyUrl), entry);
    }

    public GenericEntry getSsoSigningKey() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getEntry(new URL(this.ssoSigningKeyUrl), GenericEntry.class);
    }

    public GenericEntry getSsoSettings() throws AppsForYourDomainException, IOException, ServiceException {
        return this.getEntry(new URL(this.ssoSettingsUrl), GenericEntry.class);
    }
}

